% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/condition_comparison.R
\name{compare_conditions}
\alias{compare_conditions}
\title{Calculates PCCs and c-values based on pairwise comparison of conditions.}
\usage{
compare_conditions(result, nreps = 1000L)
}
\arguments{
\item{result}{an object of class "opafit" produced by a call to opa().}

\item{nreps}{an integer}
}
\value{
\code{compare_conditions} returns a list with the following elements

\describe{
  \item{pcc_mat}{A lower triangle matrix containing PCCs calculated from each
  pairing of data columns.}
  \item{cval_mat}{A lower triangle matrix containing c-values calculated from
  each pairing of data columns.}
  \item{pccs}{A vector containing PCCs calculated from each pairing of data.}
  \item{cvals}{A vector containing c-values calculated from each pairing of data.}
  \item{nreps}{The number of permutations used to calculate the c-values.}
  }
}
\description{
Calculates PCCs and c-values based on pairwise comparison of conditions.
}
\examples{
dat <- data.frame(t1 = c(9, 4, 8, 10),
                  t2 = c(8, 8, 12, 10),
                  t3 = c(8, 5, 10, 11),
                  t4 = c(10, 5, 11, 12))
opamod <- opa(dat, 1:4)
compare_conditions(opamod)
}
