/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ngram;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.dictionary.serializer.Attributes;
import opennlp.tools.dictionary.serializer.DictionarySerializer;
import opennlp.tools.dictionary.serializer.Entry;
import opennlp.tools.dictionary.serializer.EntryInserter;
import opennlp.tools.ngram.Token;
import opennlp.tools.ngram.TokenList;
import opennlp.tools.util.InvalidFormatException;

public class NGramModel {
    protected static final String COUNT = "count";
    private Map mNGrams = new HashMap();

    public NGramModel() {
    }

    public NGramModel(InputStream in) throws IOException, InvalidFormatException {
        DictionarySerializer.create(in, new EntryInserter(){

            public void insert(Entry entry) throws InvalidFormatException {
                int count;
                try {
                    String countValueString = entry.getAttributes().getValue(NGramModel.COUNT);
                    if (countValueString == null) {
                        throw new InvalidFormatException("The count attribute must be set!");
                    }
                    count = Integer.parseInt(countValueString);
                }
                catch (NumberFormatException e) {
                    throw new InvalidFormatException("The count attribute must be a nubmer!");
                }
                NGramModel.this.add(entry.getTokens());
                NGramModel.this.setCount(entry.getTokens(), count);
            }
        });
    }

    public int getCount(TokenList ngram) {
        Integer count = (Integer)this.mNGrams.get(ngram);
        if (count == null) {
            return 0;
        }
        return count;
    }

    public void setCount(TokenList ngram, int count) {
        Integer oldCount = this.mNGrams.put(ngram, new Integer(count));
        if (oldCount == null) {
            this.mNGrams.remove(ngram);
            throw new NoSuchElementException();
        }
    }

    public void add(TokenList ngram) {
        if (this.contains(ngram)) {
            this.setCount(ngram, this.getCount(ngram) + 1);
        } else {
            this.mNGrams.put(ngram, new Integer(1));
        }
    }

    public void add(TokenList ngram, int minLength, int maxLength) {
        for (int lengthIndex = minLength; lengthIndex < maxLength + 1; ++lengthIndex) {
            int textIndex = 0;
            while (textIndex + lengthIndex - 1 < ngram.size()) {
                Token[] grams = new Token[lengthIndex];
                for (int i = textIndex; i < textIndex + lengthIndex; ++i) {
                    grams[i - textIndex] = ngram.getToken(i);
                }
                this.add(new TokenList(grams));
                ++textIndex;
            }
        }
    }

    public void add(String chars, int minLength, int maxLength) {
        for (int lengthIndex = minLength; lengthIndex < maxLength + 1; ++lengthIndex) {
            int textIndex = 0;
            while (textIndex + lengthIndex - 1 < chars.length()) {
                String gram = chars.substring(textIndex, textIndex + lengthIndex).toLowerCase();
                this.add(new TokenList(new Token[]{Token.create(gram)}));
                ++textIndex;
            }
        }
    }

    public void remove(TokenList tokens) {
        this.mNGrams.remove(tokens);
    }

    public boolean contains(TokenList tokens) {
        return this.mNGrams.containsKey(tokens);
    }

    public int size() {
        return this.mNGrams.size();
    }

    public Iterator iterator() {
        return this.mNGrams.keySet().iterator();
    }

    public int numberOfGrams() {
        int counter = 0;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            TokenList ngram = (TokenList)it.next();
            counter += this.getCount(ngram);
        }
        return counter;
    }

    public void cutoff(int cutoffUnder, int cutoffOver) {
        if (cutoffUnder > 0 || cutoffOver < Integer.MAX_VALUE) {
            Iterator it = this.iterator();
            while (it.hasNext()) {
                TokenList ngram = (TokenList)it.next();
                int count = this.getCount(ngram);
                if (count >= cutoffUnder && count <= cutoffOver) continue;
                it.remove();
            }
        }
    }

    public Dictionary toDictionary() {
        return this.toDictionary(false);
    }

    public Dictionary toDictionary(boolean caseSensitive) {
        Dictionary dict = new Dictionary(caseSensitive);
        Iterator it = this.iterator();
        while (it.hasNext()) {
            dict.put((TokenList)it.next());
        }
        return dict;
    }

    public void serialize(OutputStream out) throws IOException {
        Iterator entryIterator = new Iterator(){
            private Iterator mDictionaryIterator;
            {
                this.mDictionaryIterator = NGramModel.this.iterator();
            }

            public boolean hasNext() {
                return this.mDictionaryIterator.hasNext();
            }

            public Object next() {
                TokenList tokens = (TokenList)this.mDictionaryIterator.next();
                Attributes attributes = new Attributes();
                attributes.setValue(NGramModel.COUNT, Integer.toString(NGramModel.this.getCount(tokens)));
                return new Entry(tokens, attributes);
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        DictionarySerializer.serialize(out, entryIterator);
    }

    public boolean equals(Object obj) {
        boolean result;
        if (obj == this) {
            result = true;
        } else if (obj instanceof NGramModel) {
            NGramModel model = (NGramModel)obj;
            result = ((Object)this.mNGrams).equals(model.mNGrams);
        } else {
            result = false;
        }
        return result;
    }

    public String toString() {
        return "Size: " + this.size();
    }

    public int hashCode() {
        return ((Object)this.mNGrams).hashCode();
    }
}

