/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedList;
import opennlp.maxent.DataStream;

public final class DataStreamBuilder
implements DataStream {
    private final Collection mData = new LinkedList();
    private Iterator mDataIterator;
    private boolean mIsIterating = false;

    public DataStreamBuilder() {
    }

    public DataStreamBuilder(Object object) {
        this();
        this.add(object);
    }

    public DataStreamBuilder(Object[] array) {
        this();
        this.add(array);
    }

    public DataStreamBuilder(Collection data) {
        this();
        this.add(data);
    }

    public void add(Object data) {
        this.checkIterating();
        this.mData.add(data);
    }

    public void add(Object[] data) {
        this.checkIterating();
        this.mData.addAll(Arrays.asList(data));
    }

    public void add(Collection data) {
        this.checkIterating();
        this.mData.addAll(data);
    }

    private void checkIterating() {
        if (this.mIsIterating) {
            throw new ConcurrentModificationException("Do not modify, after iterating started!");
        }
    }

    public Object nextToken() {
        this.mIsIterating = true;
        if (this.mDataIterator == null) {
            this.mDataIterator = this.mData.iterator();
        }
        return this.mDataIterator.next();
    }

    public boolean hasNext() {
        this.mIsIterating = true;
        if (this.mDataIterator == null) {
            this.mDataIterator = this.mData.iterator();
        }
        return this.mDataIterator.hasNext();
    }
}

