/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.namefind;

import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;
import opennlp.tools.cmdline.AbstractCrossValidatorTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.namefind.NameEvaluationErrorListener;
import opennlp.tools.cmdline.namefind.TokenNameFinderDetailedFMeasureListener;
import opennlp.tools.cmdline.namefind.TokenNameFinderTrainerTool;
import opennlp.tools.cmdline.namefind.TrainingParams;
import opennlp.tools.cmdline.params.CVParams;
import opennlp.tools.cmdline.params.DetailedFMeasureEvaluatorParams;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.namefind.TokenNameFinderCrossValidator;
import opennlp.tools.namefind.TokenNameFinderEvaluationMonitor;
import opennlp.tools.util.model.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TokenNameFinderCrossValidatorTool
extends AbstractCrossValidatorTool<NameSample, CVToolParams> {
    public TokenNameFinderCrossValidatorTool() {
        super(NameSample.class, CVToolParams.class);
    }

    @Override
    public String getShortDescription() {
        return "K-fold cross validator for the learnable Name Finder";
    }

    @Override
    public void run(String format, String[] args) {
        TokenNameFinderCrossValidator validator;
        super.run(format, args);
        this.mlParams = CmdLineUtil.loadTrainingParameters(((CVToolParams)this.params).getParams(), false);
        if (this.mlParams == null) {
            this.mlParams = ModelUtil.createTrainingParameters(((CVToolParams)this.params).getIterations(), ((CVToolParams)this.params).getCutoff());
        }
        byte[] featureGeneratorBytes = TokenNameFinderTrainerTool.openFeatureGeneratorBytes(((CVToolParams)this.params).getFeaturegen());
        Map<String, Object> resources = TokenNameFinderTrainerTool.loadResources(((CVToolParams)this.params).getResources());
        LinkedList<TokenNameFinderEvaluationMonitor> listeners = new LinkedList<TokenNameFinderEvaluationMonitor>();
        if (((CVToolParams)this.params).getMisclassified().booleanValue()) {
            listeners.add(new NameEvaluationErrorListener());
        }
        TokenNameFinderDetailedFMeasureListener detailedFListener = null;
        if (((CVToolParams)this.params).getDetailedF().booleanValue()) {
            detailedFListener = new TokenNameFinderDetailedFMeasureListener();
            listeners.add(detailedFListener);
        }
        try {
            validator = new TokenNameFinderCrossValidator(((CVToolParams)this.params).getLang(), ((CVToolParams)this.params).getType(), this.mlParams, featureGeneratorBytes, resources, listeners.toArray(new TokenNameFinderEvaluationMonitor[listeners.size()]));
            validator.evaluate(this.sampleStream, ((CVToolParams)this.params).getFolds());
        }
        catch (IOException e) {
            throw new TerminateToolException(-1, "IO error while reading training data or indexing data: " + e.getMessage(), e);
        }
        finally {
            try {
                this.sampleStream.close();
            }
            catch (IOException e) {}
        }
        System.out.println("done");
        System.out.println();
        if (detailedFListener == null) {
            System.out.println(validator.getFMeasure());
        } else {
            System.out.println(detailedFListener.toString());
        }
    }

    static interface CVToolParams
    extends TrainingParams,
    CVParams,
    DetailedFMeasureEvaluatorParams {
    }
}

