% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_ssn.R
\name{check_ssn}
\alias{check_ssn}
\title{Checking 'SSN' object.}
\usage{
check_ssn(path, predictions = NULL)
}
\arguments{
\item{path}{character; path to .ssn object.}

\item{predictions}{name(s) of prediction map(s) (optional).}
}
\value{
TRUE or FALSE depending if checks pass.
}
\description{
This function roughly checks the 'SSN' object. It returns FALSE if some 
essential columns are missing or values have illegal values.
}
\examples{
\donttest{
# Initiate and setup GRASS
dem_path <- system.file("extdata", "nc", "elev_ned_30m.tif", package = "openSTARS")
if(.Platform$OS.type == "windows"){
  grass_program_path = "c:/Program Files/GRASS GIS 7.6"
  } else {
  grass_program_path = "/usr/lib/grass78/"
  }

setup_grass_environment(dem = dem_path, 
                        gisBase = grass_program_path,      
                        remove_GISRC = TRUE,
                        override = TRUE
                        )
gmeta()

# Load files into GRASS
dem_path <- system.file("extdata", "nc", "elev_ned_30m.tif", package = "openSTARS")
sites_path <- system.file("extdata", "nc", "sites_nc.shp", package = "openSTARS")
import_data(dem = dem_path, sites = sites_path)

# Derive streams from DEM
derive_streams(burn = 0, accum_threshold = 700, condition = TRUE, clean = TRUE)

# Check and correct complex confluences (there are no complex confluences in this
# example date set; set accum_threshold in derive_streams to a smaller value
# to create complex confluences)
cj <- check_compl_confluences()
if(cj){
  correct_compl_confluences()
}

# Prepare edges
calc_edges()

# Prepare site
calc_sites()
# Calculate H2OArea
calc_attributes_sites_exact()

# Plot data
library(sp)
dem <- readRAST('dem', ignore.stderr = TRUE, plugin = FALSE)
sites <- readVECT('sites', ignore.stderr = TRUE)
sites_orig <-  readVECT('sites_o', ignore.stderr = TRUE)
edges <- readVECT('edges', ignore.stderr = TRUE)
plot(dem, col = terrain.colors(20))
lines(edges, col = 'blue')
points(sites_orig, pch = 4)
cols <- colorRampPalette(c("blue", 'red'))(length(sites$H2OArea))[rank(sites$H2OArea)]
points(sites, pch = 16, col = cols)

# Write data to SSN Folder
ssn_dir <- file.path(tempdir(), 'nc.ssn')
export_ssn(ssn_dir, delete_directory = TRUE)

# Check if all files are ok
library(SSN)
check_ssn(ssn_dir)
}
}
\author{
Mira Kattwinkel, \email{mira.kattwinkel@gmx.net},
  Eduard Szoecs, \email{eduardszoecs@gmail.com}
}
