% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_sites_measurements.R
\name{merge_sites_measurements}
\alias{merge_sites_measurements}
\title{Merge a table with measurements to the sites.}
\usage{
merge_sites_measurements(measurements, site_id, all_sites = FALSE, ...)
}
\arguments{
\item{measurements}{character string, data.table or data.frame object; 
path to table data containing the data or a data.table or data.frame object}

\item{site_id}{character string; columns name that gives the unique name of the
site. Must be identical in both the sites vector object and the table of 
measurements}

\item{all_sites}{logical; should sites without measurements be preserved (default FALSE)}

\item{...}{additional arguments to read.table in case \code{measuremtes} is a file path
to table data; see \code{\link{read.table}} for details.}
}
\description{
After all processing steps are done and before exporting as an SSN object
 measurements can be added to the site map. They can contain multiple parameters and
 repeated measurements at the same site.
}
\details{
Measurements are merged to the sites objects based on \code{site_id}. If
 there are repeated measurements, point features are duplicated and the 'pid' of the 
 sites is updated accordingly to be unique.
}
\examples{
\donttest{
dem_path <- system.file("extdata", "nc", "elev_ned_30m.tif", package = "openSTARS")
if(.Platform$OS.type == "windows"){
  grass_program_path = "c:/Program Files/GRASS GIS 7.6"
  } else {
  grass_program_path = "/usr/lib/grass78/"
  }

setup_grass_environment(dem = dem_path, 
                        gisBase = grass_program_path,      
                        remove_GISRC = TRUE,
                        override = TRUE
                        )
gmeta()
                        
# Load files into GRASS
dem_path <- system.file("extdata", "nc", "elev_ned_30m.tif", package = "openSTARS")
sites_path <- system.file("extdata", "nc", "sites_nc.shp", package = "openSTARS")
import_data(dem = dem_path, sites = sites_path)

# Derive streams from DEM
derive_streams(burn = 0, accum_threshold = 700, condition = TRUE, clean = TRUE)

# Check and correct complex junctions (there are no complex confluences in this
# example date set)
cj <- check_compl_confluences()
if(cj){
  correct_compl_confluences()
}

# Prepare edges
calc_edges()

# Prepare site
calc_sites()

merge_sites_measurements(measurements = system.file(
  "extdata", "nc", "obs_data.csv", package = "openSTARS"),
   site_id = "site_id", sep = ",", dec = ".")
# note the dublicated rows, and the new columns at the end
sites <- readVECT("sites", ignore.stderr = TRUE)
head(sites@data, n = 6)
}
}
\author{
Mira Kattwinkel \email{mira.kattwinkel@gmx.net}
}
