% Generated by roxygen2 (4.0.1): do not edit by hand
\name{airbaseSplice}
\alias{airbaseSplice}
\title{Function to simplify and combine airbase data imports}
\usage{
airbaseSplice(dat, drop = TRUE)
}
\arguments{
\item{dat}{Data (a data frame) that has been imported using the
\code{importAirbase} function.}

\item{drop}{Should the original columns be dropped or kept. The
default is to remove (drop) them.}
}
\value{
A simplified data frame.
}
\description{
Function to simplify and combine airbase data imports
}
\details{
Airbase keeps a detailed account of the instruments used for
measuring different species. For the same species several
different instruments can be used over time. For example, for NOx
a broken instrument could be replaced by a new one. In airbase
these two instruments will results in two separate time series
identified through the airbase measurement_european_group_code
(with numbers like 100, 101, 102). When data are imported using
the \code{importAirbase} function the different measurement codes
are retained in the pollutant names if more than one code is used,
resulting in names like NOX|101, NOX|102 and so on.

For \sQuote{simple} species such as NOx there is generally no
reason to keep two separate time series and it would seem
reasonable to combine them into a single species NOX. This is what
the \code{airbaseSplice} function does. It will combine multiple
measurements of the same species into a new single species. In
cases where there is overlap, more recent instrument measurements
take precedence over older instrument measurements.

In other cases it can be sensible to keep the different
measurements of the same species separate. An example of such a
case is for PM10 where, for example, moving from TEOM to FDMS
measurements produces time series that cannot (or should not) be
easily be merged.

Rather than combine all pollutant measurements of the same species
by default it was thought important to retain this information to
allow users more flexibility.

If \code{drop = TRUE} then the original columns are not
retained. For example, given original columns NOX|101, NOX|102 the
new data frame will have only one column NOX. Conversely, if
\code{drop = FALSE} then the final data frame will have three
species: NOX|101, NOX|102 and a new combined field NOX.
}
\author{
David Carslaw
}

