% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oaApiRequest.R
\name{oa_request}
\alias{oa_request}
\title{Get bibliographic records from OpenAlex databases}
\usage{
oa_request(
  query_url,
  per_page = 200,
  count_only = FALSE,
  mailto = oa_email(),
  verbose = FALSE
)
}
\arguments{
\item{query_url}{is a character. It contains a search query formulated using the OpenAlex API language. A query can be automatically generated using the function \code{oa_query}.}

\item{per_page}{is a numeric. It indicates how many items to download per page. The per-page argument can assume any number between 1 and 200. Default is \code{per_page=200}.}

\item{count_only}{is a logical. If TRUE, the function returns only the number of item matching the query. Default is \code{count_only=FALSE}.}

\item{mailto}{is a character. To get into the polite pool, the arguments mailto have to give OpenAlex an email where they can contact you.}

\item{verbose}{is a logical. If TRUE, information about the querying process will be plotted on screen. Default is \code{verbose=FALSE}.}
}
\value{
a data.frame or a list.

For more extensive information about OpenAlex API, please visit: \href{https://docs.openalex.org/api}{https://docs.openalex.org/api}
}
\description{
It gets bibliographic records from OpenAlex database \href{https://openalex.org/}{https://openalex.org/}.
The function \code{oa_request} queries OpenAlex database using a query formulated through the function \code{oa_query}.
}
\examples{
\dontrun{

### EXAMPLE 1: Full record about an entity.

# Query to obtain all information about a particular work/author/institution/etc.:

#  The following paper is associated to the OpenAlex-id W2755950973.

#  Aria, M., & Cuccurullo, C. (2017). bibliometrix:
#   An R-tool for comprehensive science mapping analysis.
#   Journal of informetrics, 11(4), 959-975.


query_work <- oa_query(
  identifier = "W2755950973",
  entity = "works",
  endpoint = "https://api.openalex.org/"
)

res <- oa_request(
  query_url = query_work,
  count_only = FALSE,
  verbose = FALSE
)

#  The author Massimo Aria is associated to the OpenAlex-id A923435168.


query_author <- oa_query(
  identifier = "A923435168",
  entity = "authors",
  endpoint = "https://api.openalex.org/"
)

res <- oa_request(
  query_url = query_author,
  count_only = FALSE,
  verbose = FALSE
)



### EXAMPLE 2: all works citing a particular work.

# Query to search all works citing the article:
#  Aria, M., & Cuccurullo, C. (2017). bibliometrix:
#   An R-tool for comprehensive science mapping analysis.
#   Journal of informetrics, 11(4), 959-975.

#  published in 2021.
#  The paper is associated to the OpenAlex id W2755950973.

#  Results have to be sorted by relevance score in a descending order.

query2 <- oa_query(
  identifier = NULL,
  entity = "works",
  filter = "cites:W2755950973",
  from_publication_date = "2021-01-01",
  to_publication_date = "2021-12-31",
  search = NULL,
  endpoint = "https://api.openalex.org/"
)

res2 <- oa_request(
  query_url = query2,
  count_only = FALSE,
  verbose = FALSE
)

### EXAMPLE 3: All works matching a string in their title

# Query to search all works containing the exact string
# "bibliometric analysis" OR "science mapping" in the title, published in 2020 or 2021.

# Results have to be sorted by relevance score in a descending order.


query3 <- oa_query(
  identifier = NULL,
  entity = "works",
  filter = 'title.search:"bibliometric analysis"|"science mapping"',
  from_publication_date = "2020-01-01",
  to_publication_date = "2021-12-31",
  search = NULL,
  endpoint = "https://api.openalex.org/"
)

res3 <- oa_request(
  query_url = query3,
  count_only = FALSE,
  verbose = FALSE
)

### EXAMPLE 4: How to check how many works match a query
# Query to search all works containing the exact string
# "bibliometric analysis" OR "science mapping" in the title, published in 2020 or 2021.

# Query only to know how many works could be retrieved (count_only=TRUE)

query4 <- oa_query(
  identifier = NULL,
  entity = "works",
  filter = 'title.search:"bibliometric analysis"|"science mapping"',
  from_publication_date = "2020-01-01",
  to_publication_date = "2021-12-31",
  search = NULL,
  endpoint = "https://api.openalex.org/"
)

res4 <- oa_request(
  query_url = query4,
  count_only = TRUE,
  verbose = FALSE
)

res4$count # number of items retrieved by our query
}
}
