% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/start.R
\name{ocpu-server}
\alias{ocpu-server}
\alias{ocpu_start_server}
\alias{opencpu}
\alias{ocpu}
\alias{ocpu_start_app}
\title{OpenCPU Single-User Server}
\usage{
ocpu_start_server(port = 5656, root = "/ocpu", workers = 2,
  preload = NULL, on_startup = NULL)

ocpu_start_app(app, ...)
}
\arguments{
\item{port}{port number}

\item{root}{base of the URL where to host the OpenCPU API}

\item{workers}{number of worker processes}

\item{preload}{character vector of packages to preload in the workers. This speeds
up requests to those packages.}

\item{on_startup}{function to call once server has started (e.g. \code{browseURL})}

\item{app}{either the name of a locally installed package, or a github remote
(see \link{install_github})}

\item{...}{extra parameters passed to \link{ocpu_start_server}}
}
\description{
Starts the OpenCPU single-user server for developing and running apps locally.
To deploy your apps on a cloud server or \href{https://ocpu.io}{ocpu.io}, simply
push them to github and install the opencpu webhook. Some example apps are available
from \url{https://github.com/rwebapps}.
}
\examples{
\dontrun{
# List available demo apps
available_apps()

# Run application from: https://github.com/rwebapps/nabel
ocpu_start_app("rwebapps/nabel")

# Run application from: https://github.com/rwebapps/markdownapp
ocpu_start_app("rwebapps/markdownapp")

# Run application from: https://github.com/rwebapps/stockapp
ocpu_start_app("rwebapps/stockapp")

# Run application from: https://github.com/rwebapps/appdemo
ocpu_start_app("rwebapps/appdemo")

# Show currently installed apps
installed_apps()
}
}
\seealso{
Other ocpu: \code{\link{apps}}
}
