% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getmetadata_odf.R
\name{getmetadata_odf}
\alias{getmetadata_odf}
\title{Get variable labels or other metadata from a data frame in
opendataformat.}
\usage{
getmetadata_odf(input, type, language = "active")
}
\arguments{
\item{input}{R data frame (df) or variable from an R data frame (df$var).}

\item{type}{The metadata type you want to retrieve.Possible options are
"label", "description", "url", "type", "valuelabels",
or "languages".}

\item{language}{Select the language in which the labels of the variables
will be displayed. If no language is selected, the current/active language
of the data frame will be used.
\itemize{
\item By default the language that is set to current is displayed
(\code{language = "current"}). \item You can select the language
by language code, e.g. \code{language = "en"}.
}}
}
\value{
Documentation.
}
\description{
Get access to information about the dataset
and variables via the R-Studio Viewer or the web browser.
}
\examples{
# get example data from the opendataformat package
df <- get(data("data_odf"))
# view the variable labels for all variables in English
getmetadata_odf(input = df, type = "label", language = "en")

# view the value labels for variable bap87 in English
getmetadata_odf(input = df$bap87, type = "valuelabel", language = "en")

# view the description for variable bap87 in English
getmetadata_odf(input = df$bap87, type = "description", language = "en")

}
