% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/argument_types.R
\name{AnyOf}
\alias{AnyOf}
\title{AnyOf}
\value{
Object of \code{\link{R6Class}} representing an argument choice object.
}
\description{
Inheriting from \code{\link{Argument}} in order to represent an argument choice object. Multiple
types can be stated, but at least one data type has to be picked. In a JSON-schema this is often used to make
objects nullable - meaning that they allow NULL as value. The AnyOf parameter is resolved into a simple nullable argument
if this applies.
}
\section{Methods}{

\describe{
  \item{\code{$getChoice()}}{returns a list of \code{\link{Argument}} that are allowed}
  \item{\code{$isNullable}}{returns TRUE if only one element is in the choice that is not "null"}
}
}

\seealso{
\code{\link{Array}}, \code{\link{Integer}}, \code{\link{EPSGCode}}, \code{\link{String}}, \code{\link{Number}}, 
\code{\link{Date}}, \code{\link{RasterCube}}, \code{\link{VectorCube}}, \code{\link{ProcessGraphArgument}}, 
\code{\link{ProcessGraphParameter}}, \code{\link{OutputFormatOptions}}, \code{\link{GeoJson}},
\code{\link{Boolean}}, \code{\link{DateTime}}, \code{\link{Time}}, \code{\link{BoundingBox}}, \code{\link{Kernel}}, 
\code{\link{TemporalInterval}}, \code{\link{TemporalIntervals}}, \code{\link{CollectionId}}, \code{\link{OutputFormat}},
\code{\link{AnyOf}}, \code{\link{ProjDefinition}}, \code{\link{UdfCodeArgument}}, \code{\link{UdfRuntimeArgument}} and 
\code{\link{UdfRuntimeVersionArgument}}
}
