% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/base64.R
\name{base64}
\alias{base64}
\alias{base64_decode}
\alias{base64_encode}
\title{Encode and decode base64}
\usage{
base64_encode(bin, linebreaks = FALSE)

base64_decode(text)
}
\arguments{
\item{bin}{Data to encode. Must be raw or character vector.}

\item{linebreaks}{Insert linebreaks in the base64 message to make it more readable.}

\item{text}{The base64 message to decode. Must be a string.}
}
\description{
Encode and decode binary data into a base64 string. Character vectors are
automatically collapse into a single string.
}
\examples{
input <- charToRaw("foo = bar + 5")
message <- base64_encode(input)
output <- base64_decode(message)
identical(output, input)
}

