% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkcs12.R
\name{write_p12}
\alias{write_p12}
\alias{pkcs12}
\alias{pfx}
\alias{write_p7b}
\alias{read_p12}
\alias{read_p7b}
\title{PKCS7 / PKCS12 bundles}
\usage{
write_p12(key = NULL, cert = NULL, ca = NULL, name = NULL,
  password = NULL, path = NULL)

write_p7b(ca, path = NULL)

read_p12(file, password = askpass)

read_p7b(file, der = is.raw(file))
}
\arguments{
\item{key}{a private key}

\item{cert}{certificate that matches `key`}

\item{ca}{a list of certificates (the CA chain)}

\item{name}{a friendly title for the bundle}

\item{password}{string or function to set/get the password.}

\item{path}{a file where to write the output to. If `NULL` the output is returned
as a raw vector.}

\item{file}{path or raw vector with binary PKCS12 data to parse}

\item{der}{set to TRUE for binary files and FALSE for PEM files}
}
\description{
PKCS7 and PKCS12 are container formats for storing multiple certificates and/or keys.
}
\details{
The PKCS#7 or P7B format is a container for one or more certificates. It can either
be stored in binary form or in a PEM file. P7B files are typically used to import
and export public certificates.

The PKCS#12 or PFX format is a binary-only format for storing the server certificate,
any intermediate certificates, and the private key into a single encryptable file.
PFX files are usually found with the extensions .pfx and .p12. PFX files are typically
used to import and export certificates with their private keys.

The PKCS formats also allow for including signatures and CRLs but this is quite rare
and these are currently ignored.
}
