% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R,
%   R/get-named-regions.R
\name{named_region}
\alias{named_region}
\alias{wb_add_named_region}
\alias{wb_remove_named_region}
\alias{get_named_regions}
\alias{wb_get_named_regions}
\title{Create / delete a named region}
\usage{
wb_add_named_region(
  wb,
  sheet = current_sheet(),
  cols,
  rows,
  name,
  localSheet = FALSE,
  overwrite = FALSE,
  comment = NULL,
  customMenu = NULL,
  description = NULL,
  is_function = NULL,
  functionGroupId = NULL,
  help = NULL,
  hidden = NULL,
  localName = NULL,
  publishToServer = NULL,
  statusBar = NULL,
  vbProcedure = NULL,
  workbookParameter = NULL,
  xml = NULL
)

wb_remove_named_region(wb, sheet = current_sheet(), name = NULL)

get_named_regions(x)

wb_get_named_regions(x)
}
\arguments{
\item{wb}{A workbook object}

\item{sheet}{A name or index of a worksheet}

\item{cols}{Numeric vector specifying columns to include in region}

\item{rows}{Numeric vector specifying rows to include in region}

\item{name}{Name for region. A character vector of length 1. Note region names musts be case-insensitive unique.}

\item{localSheet}{If \code{TRUE} the named region will be local for this sheet}

\item{overwrite}{Boolean. Overwrite if exists? Default to FALSE}

\item{comment}{description text for named region}

\item{customMenu}{customMenu (unknown xml feature)}

\item{description}{description (unknown xml feature)}

\item{is_function}{function (unknown xml feature)}

\item{functionGroupId}{function group id (unknown xml feature)}

\item{help}{help (unknown xml feature)}

\item{hidden}{hidden if the named region should be hidden}

\item{localName}{localName (unknown xml feature)}

\item{publishToServer}{publish to server (unknown xml feature)}

\item{statusBar}{status bar (unknown xml feature)}

\item{vbProcedure}{wbProcedure (unknown xml feature)}

\item{workbookParameter}{workbookParameter (unknown xml feature)}

\item{xml}{xml (unknown xml feature)}

\item{x}{An xlsx file or Workbook object}
}
\description{
Create / delete a named region

Return a vector of named regions in a xlsx file or
Workbook object
}
\details{
Region is given by: min(cols):max(cols) X min(rows):max(rows)
}
\examples{
## create named regions
wb <- wb_workbook()
wb$add_worksheet("Sheet 1")

## specify region
wb$add_data(sheet = 1, x = iris, startCol = 1, startRow = 1)
wb$add_named_region(
  sheet = 1,
  name = "iris",
  rows = seq_len(nrow(iris) + 1),
  cols = seq_along(iris)
)


## using write_data 'name' argument
wb$add_data(sheet = 1, x = iris, name = "iris2", startCol = 10)

out_file <- temp_xlsx()
wb_save(wb, out_file, overwrite = TRUE)

## see named regions
wb_get_named_regions(wb) ## From Workbook object
wb_get_named_regions(out_file) ## From xlsx file

## delete one
wb$remove_named_region(name = "iris2")
wb_get_named_regions(wb)

## read named regions
df <- read_xlsx(wb, namedRegion = "iris")
head(df)

df <- read_xlsx(out_file, namedRegion = "iris2")
head(df)
## create named regions
wb <- wb_workbook()
wb$add_worksheet("Sheet 1")

## specify region
wb$add_data(sheet = 1, x = iris, startCol = 1, startRow = 1)
wb$add_named_region(
  sheet = 1,
  name = "iris",
  rows = seq_len(nrow(iris) + 1),
  cols = seq_along(iris)
)


## using write_data 'name' argument to create a named region
wb$add_data(sheet = 1, x = iris, name = "iris2", startCol = 10)

out_file <- temp_xlsx()
wb$save(out_file, overwrite = TRUE)

## see named regions
wb_get_named_regions(wb) ## From Workbook object
wb_get_named_regions(out_file) ## From xlsx file

## read named regions
df <- read_xlsx(wb, namedRegion = "iris")
head(df)

df <- read_xlsx(out_file, namedRegion = "iris2")
head(df)
}
\seealso{
\code{\link[=wb_add_named_region]{wb_add_named_region()}} \code{\link[=wb_remove_named_region]{wb_remove_named_region()}}
}
