% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_add_data_table}
\alias{wb_add_data_table}
\title{Add a data table to a worksheet}
\usage{
wb_add_data_table(
  wb,
  sheet = current_sheet(),
  x,
  dims = wb_dims(start_row, start_col),
  start_col = 1,
  start_row = 1,
  col_names = TRUE,
  row_names = FALSE,
  table_style = "TableStyleLight9",
  table_name = NULL,
  with_filter = TRUE,
  sep = ", ",
  first_column = FALSE,
  last_column = FALSE,
  banded_rows = TRUE,
  banded_cols = FALSE,
  apply_cell_style = TRUE,
  remove_cell_style = FALSE,
  na.strings = na_strings(),
  inline_strings = TRUE,
  ...
)
}
\arguments{
\item{wb}{A Workbook object containing a worksheet.}

\item{sheet}{The worksheet to write to. Can be the worksheet index or name.}

\item{x}{A data frame}

\item{dims}{Spreadsheet cell range that will determine \code{start_col} and \code{start_row}: "A1", "A1:B2", "A:B"}

\item{start_col}{A vector specifying the starting column to write \code{x} to.}

\item{start_row}{A vector specifying the starting row to write \code{x} to.}

\item{col_names}{If \code{TRUE}, column names of \code{x} are written.}

\item{row_names}{If \code{TRUE}, the row names of \code{x} are written.}

\item{table_style}{Any table style name or "none" (see \code{vignette("openxlsx2_style_manual")})}

\item{table_name}{Name of table in workbook. The table name must be unique.}

\item{with_filter}{If \code{TRUE}, columns with have filters in the first row.}

\item{sep}{Only applies to list columns. The separator used to collapse list
columns to a character vector e.g.
\code{sapply(x$list_column, paste, collapse = sep)}.
\cr\cr
\cr\strong{The below options correspond to Excel table options:}
\cr
\if{html}{\figure{tableoptions.png}{options: width="40\%" alt="Figure: table_options.png"}}
\if{latex}{\figure{tableoptions.pdf}{options: width=7cm}}}

\item{first_column}{logical. If \code{TRUE}, the first column is bold.}

\item{last_column}{logical. If \code{TRUE}, the last column is bold.}

\item{banded_rows}{logical. If \code{TRUE}, rows are color banded.}

\item{banded_cols}{logical. If \code{TRUE}, the columns are color banded.}

\item{apply_cell_style}{Should we write cell styles to the workbook}

\item{remove_cell_style}{keep the cell style?}

\item{na.strings}{Value used for replacing \code{NA} values from \code{x}. Default
\code{\link[=na_strings]{na_strings()}} uses the special \verb{#N/A} value within the workbook.}

\item{inline_strings}{write characters as inline strings}

\item{...}{additional arguments}
}
\description{
Add data to a worksheet and format as an Excel table.
}
\details{
The columns of \code{x} with class Date/POSIXt, currency, accounting, hyperlink,
percentage are automatically styled as dates, currency, accounting, hyperlinks,
percentages respectively.

The string \code{"_openxlsx_NA"} is reserved for \code{openxlsx2}. If \code{x} contains this
string, the output will be broken.
}
\seealso{
Other worksheet content functions: 
\code{\link{col_widths-wb}},
\code{\link{filter-wb}},
\code{\link{grouping-wb}},
\code{\link{named_region-wb}},
\code{\link{row_heights-wb}},
\code{\link{wb_add_conditional_formatting}()},
\code{\link{wb_add_data}()},
\code{\link{wb_add_formula}()},
\code{\link{wb_add_pivot_table}()},
\code{\link{wb_add_thread}()},
\code{\link{wb_freeze_pane}()},
\code{\link{wb_merge_cells}()}

Other workbook wrappers: 
\code{\link{base_font-wb}},
\code{\link{col_widths-wb}},
\code{\link{creators-wb}},
\code{\link{grouping-wb}},
\code{\link{row_heights-wb}},
\code{\link{wb_add_chartsheet}()},
\code{\link{wb_add_data}()},
\code{\link{wb_add_formula}()},
\code{\link{wb_add_pivot_table}()},
\code{\link{wb_add_worksheet}()},
\code{\link{wb_clone_worksheet}()},
\code{\link{wb_copy_cells}()},
\code{\link{wb_freeze_pane}()},
\code{\link{wb_merge_cells}()},
\code{\link{wb_save}()},
\code{\link{wb_set_last_modified_by}()},
\code{\link{wb_workbook}()}
}
\concept{workbook wrappers}
\concept{worksheet content functions}
