% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wb_styles.R
\name{create_border}
\alias{create_border}
\title{Create border format}
\usage{
create_border(
  diagonal_down = "",
  diagonal_up = "",
  outline = "",
  bottom = NULL,
  bottom_color = NULL,
  diagonal = NULL,
  diagonal_color = NULL,
  end = "",
  horizontal = "",
  left = NULL,
  left_color = NULL,
  right = NULL,
  right_color = NULL,
  start = "",
  top = NULL,
  top_color = NULL,
  vertical = "",
  start_color = NULL,
  end_color = NULL,
  horizontal_color = NULL,
  vertical_color = NULL,
  ...
)
}
\arguments{
\item{diagonal_down, diagonal_up}{Logical, whether the diagonal border goes from the bottom left to the top right, or top left to bottom right.}

\item{outline}{Logical, whether the border is.}

\item{bottom, left, right, top, diagonal}{Character, the style of the border.}

\item{bottom_color, left_color, right_color, top_color, diagonal_color, start_color, end_color, horizontal_color, vertical_color}{a \code{\link[=wb_color]{wb_color()}}, the color of the border.}

\item{horizontal, vertical}{Character, the style of the inner border (only for dxf objects).}

\item{start, end}{leading and trailing edge of a border.}

\item{...}{Additional arguments passed to other methods.}
}
\value{
A formatted border object to be used in a spreadsheet.
}
\description{
This function creates border styles for a cell in a spreadsheet. Border styles can be any of the following: "none", "thin", "medium", "dashed", "dotted", "thick", "double", "hair", "mediumDashed", "dashDot", "mediumDashDot", "dashDotDot", "mediumDashDotDot", "slantDashDot". Border colors can be created with \code{\link[=wb_color]{wb_color()}}.
}
\examples{
# Create a border with a thick bottom and thin top
border <- create_border(
  bottom = "thick",
  bottom_color = wb_color("FF0000"),
  top = "thin",
  top_color = wb_color("00FF00")
)

}
\seealso{
\code{\link[=wb_add_border]{wb_add_border()}}

Other style creating functions: 
\code{\link{create_cell_style}()},
\code{\link{create_colors_xml}()},
\code{\link{create_dxfs_style}()},
\code{\link{create_fill}()},
\code{\link{create_font}()},
\code{\link{create_numfmt}()},
\code{\link{create_tablestyle}()}
}
\concept{style creating functions}
