% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{wb_dims}
\alias{wb_dims}
\title{Helper to specify the \code{dims} argument}
\usage{
wb_dims(..., select = NULL)
}
\arguments{
\item{...}{construct \code{dims} arguments, from rows/cols vectors or objects that
can be coerced to data frame. \code{x}, \code{rows}, \code{cols}, \code{from_row}, \code{from_col}, \code{from_dims}
\code{row_names}, and \code{col_names} are accepted.}

\item{select}{A string, one of the followings.
it improves the selection of various parts of \code{x}
One of "x", "data", "col_names", or "row_names".
\code{"data"} will only select the data part, excluding row names and column names  (default if \code{cols} or \code{rows} are specified)
\code{"x"} Includes the data, column and row names if they are present. (default if none of \code{rows} and \code{cols} are provided)
\code{"col_names"} will only return column names
\code{"row_names"} Will only return row names.}
}
\value{
A \code{dims} string
}
\description{
\code{wb_dims()} can be used to help provide the \code{dims} argument, in the \verb{wb_add_*} functions.
It returns a A1 spreadsheet range ("A1:B1" or "A2").
It can be very useful as you can specify many parameters that interact together
In general, you must provide named arguments. \code{wb_dims()} will only accept unnamed arguments
if they are \code{rows}, \code{cols}, for example \code{wb_dims(1:4, 1:2)}, that will return "A1:B4".

\code{wb_dims()} can also be used with an object (a \code{data.frame} or a \code{matrix} for example.)
All parameters are numeric unless stated otherwise.
}
\details{
When using \code{wb_dims()} with an object, the default behavior is
to select only the data / row or columns in \code{x}
If you need another behavior, use \code{wb_dims()} without supplying \code{x}.
\itemize{
\item \code{x} An object (typically a \code{matrix} or a \code{data.frame}, but a vector is also accepted.)
\item \code{from_row} / \code{from_col} / \code{from_dims} the starting position of \code{x}
(The \code{dims} returned will assume that the top left corner of \code{x} is at \code{from_row / from_col}
\item \code{rows} Optional Which row span in \code{x} should this apply to.
If \code{rows} = 0, only column names will be affected.
\item \code{cols} a range of columns id in \code{x}, or one of the column names of \code{x}
(length 1 only accepted for column names of \code{x}.)
\item \code{row_names} A logical, this is to let \code{wb_dims()} know that \code{x} has row names or not.
If \code{row_names = TRUE}, \code{wb_dims()} will increment \code{from_col} by 1.
\item \code{col_names} \code{wb_dims()} assumes that if \code{x} has column names, then trying to find the \code{dims}.
}

\code{wb_dims()} tries to support most possible cases with \code{row_names = TRUE} and \code{col_names = FALSE},
but it works best if \code{x} has named dimensions (\code{data.frame}, \code{matrix}), and those parameters are not specified.
data with column names, and without row names. as the code is more clean.

In the \code{add_data()} / \code{add_font()} example, if writing the data with row names

While it is possible to construct dimensions from decreasing rows and columns, the output will always order the rows top to bottom. So
\code{wb_dims(rows = 3:1, cols = 3:1)} will not result in \code{"C3:A1"} and if passed to functions, it will return the same as \code{"C1:A3"}.
}
\section{Using \code{wb_dims()} without an \code{x} object}{
\itemize{
\item \code{rows} / \code{cols} (if you want to specify a single one, use \code{from_row} / \code{from_col})
\item \code{from_row} / \code{from_col} the starting position of the \code{dims}
(similar to \code{start_row} / \code{start_col}, but with a clearer name.)
}
}

\section{Using \code{wb_dims()} with an \code{x} object}{
\code{wb_dims()} with an object has 8 use-cases (they work with any position values of \code{from_row} / \code{from_col}),
\code{from_col/from_row} correspond to the coordinates at the top left of \code{x} including column and row names if present.

These use cases are provided without \code{from_row / from_col}, but they work also with \code{from_row / from_col}.
\enumerate{
\item provide the full grid with \code{wb_dims(x = mtcars)}
\item provide the data grid \code{wb_dims(x = mtcars, select = "data")}
\item provide the \code{dims} of column names \code{wb_dims(x = mtcars, select = "col_names")}
\item provide the \code{dims} of row names  \code{wb_dims(x = mtcars, row_names = TRUE, select = "row_names")}
\item provide the \code{dims} of a row span \code{wb_dims(x = mtcars, rows = 1:10)} selects
the first 10 data rows of \code{mtcars} (ignoring column names)
\item provide the \code{dims} of the data in a column span \code{wb_dims(x = mtcars, cols = 1:5)}
select the data first 5 columns of \code{mtcars}
\item provide a column span (including column names) \code{wb_dims(x = mtcars, cols = 4:7, select = "x")}
select the data columns 4, 5, 6, 7 of \code{mtcars} + column names
\item provide the position of a single column by name \code{wb_dims(x = mtcars, cols = "mpg")}.
\item provide a row span with a column. \code{wb_dims(x = mtcars, cols = "mpg", rows = 5:22)}
}

To reuse, a good trick is to create a wrapper function, so that styling can be
performed seamlessly.

\if{html}{\out{<div class="sourceCode R">}}\preformatted{wb_dims_cars <- function(...) \{
  wb_dims(x = mtcars, from_row = 2, from_col = "B", ...)
\}
# using this function
wb_dims_cars()                     # full grid (data + column names)
wb_dims_cars(select = "data")      # data only
wb_dims_cars(select = "col_names") # select column names
wb_dims_cars(cols = "vs")          # select the `vs` column
}\if{html}{\out{</div>}}

It can be very useful to apply many rounds of styling sequentially.
}

\examples{
# Provide coordinates
wb_dims(1, 4)
wb_dims(rows = 1, cols = 4)
wb_dims(from_row = 4)
wb_dims(from_col = 2)
wb_dims(from_col = "B")
wb_dims(1:4, 6:9, from_row = 5)
# Provide vectors
wb_dims(1:10, c("A", "B", "C"))
wb_dims(rows = 1:10, cols = 1:10)
# provide `from_col` / `from_row`
wb_dims(rows = 1:10, cols = c("A", "B", "C"), from_row = 2)
wb_dims(rows = 1:10, cols = 1:10, from_col = 2)
wb_dims(rows = 1:10, cols = 1:10, from_dims = "B1")
# or objects
wb_dims(x = mtcars, col_names = TRUE)

# select all data
wb_dims(x = mtcars, select = "data")

# column names of an object (with the special select = "col_names")
wb_dims(x = mtcars, select = "col_names")


# dims of the column names of an object
wb_dims(x = mtcars, select = "col_names", col_names = TRUE)

## add formatting to `mtcars` using `wb_dims()`----
wb <- wb_workbook()
wb$add_worksheet("test wb_dims() with an object")
dims_mtcars_and_col_names <- wb_dims(x = mtcars)
wb$add_data(x = mtcars, dims = dims_mtcars_and_col_names)

# Put the font as Arial for the data
dims_mtcars_data <- wb_dims(x = mtcars, select = "data")
wb$add_font(dims = dims_mtcars_data, name = "Arial")

# Style col names as bold using the special `select = "col_names"` with `x` provided.
dims_column_names <- wb_dims(x = mtcars, select = "col_names")
wb$add_font(dims = dims_column_names, bold = TRUE, size = 13)

# Finally, to add styling to column "cyl" (the 4th column) (only the data)
# there are many options, but here is the preferred one
# if you know the column index, wb_dims(x = mtcars, cols = 4) also works.
dims_cyl <- wb_dims(x = mtcars, cols = "cyl")
wb$add_fill(dims = dims_cyl, color = wb_color("pink"))

# Mark a full column as important(with the column name too)
wb_dims_vs <- wb_dims(x = mtcars, cols = "vs", select = "x")
wb$add_fill(dims = wb_dims_vs, fill = wb_color("yellow"))
wb$add_conditional_formatting(dims = wb_dims(x = mtcars, cols = "mpg"), type = "dataBar")
# wb_open(wb)

# fix relative ranges
wb_dims(x = mtcars) # equal to none: A1:K33
wb_dims(x = mtcars, fix = "all") # $A$1:$K$33
wb_dims(x = mtcars, fix = "row") # A$1:K$33
wb_dims(x = mtcars, fix = "col") # $A1:$K33
wb_dims(x = mtcars, fix = c("col", "row")) # $A1:K$33
}
