% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wb_load.R
\name{wb_load}
\alias{wb_load}
\title{Load an existing .xlsx file}
\usage{
wb_load(file, sheet, data_only = FALSE, calc_chain = FALSE, ...)
}
\arguments{
\item{file}{A path to an existing .xlsx, .xlsm or .xlsb file}

\item{sheet}{optional sheet parameter. if this is applied, only the selected
sheet will be loaded. This can be a numeric, a string or \code{NULL}.}

\item{data_only}{mode to import if only a data frame should be returned. This
strips the \code{wbWorkbook} to a bare minimum.}

\item{calc_chain}{optionally you can keep the calculation chain intact. This
is used by spreadsheet software to identify the order in which formulas are
evaluated. Removing the calculation chain is considered harmless. The calc
chain will be created upon the next time the worksheet is loaded in
spreadsheet software. Keeping it, might only speed loading time in said
software.}

\item{...}{additional arguments}
}
\value{
A Workbook object.
}
\description{
\code{wb_load()} returns a \link{wbWorkbook} object conserving styles and
formatting of the original input file.
}
\details{
A warning is displayed if an xml namespace for main is found in the xlsx file.
Certain xlsx files created by third-party applications contain a namespace
(usually \code{x}). This namespace is not required for the file to work in spreadsheet
software and is not expected by \code{openxlsx2}. Therefore it is removed when the
file is loaded into a workbook. Removal is generally expected to be safe,
but the feature is still experimental.

Initial support for binary openxml files (\code{xlsb}) has been added to the package.
We parse the binary file format into pseudo-openxml files that we can import.
Therefore, after importing, it is possible to interact with the file as if it
had been provided as xlsx in the first place. This is of course slower than
reading directly from the binary file. Our implementation is also still missing
some features: some array formulas are still broken, conditional formatting and
data validation are not implemented, nor are pivot tables and slicers.

It is possible to import with \code{wb_load(data_only = TRUE, sheet = NULL)}. This
way only a workbook skeleton is loaded. This can be useful if only some
workbook properties are of interest.
}
\examples{
## load existing workbook from package folder
wb <- wb_load(file = system.file("extdata", "openxlsx2_example.xlsx", package = "openxlsx2"))
wb$get_sheet_names() # list worksheets
wb ## view object
## Add a worksheet
wb$add_worksheet("A new worksheet")
}
