% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-terms.r
\name{model_terms}
\alias{model_terms}
\title{Parse a formula object into its left-hand-side and right-hand-side components}
\usage{
model_terms(x)
}
\arguments{
\item{x}{Formula to parse}
}
\value{
list with named elements "lhs" and "rhs", containing variables on each respective side of the equation
}
\description{
Parse a formula object into its left-hand-side and right-hand-side components
}
\examples{
# Set up a hypothetical function, then decompose into left-hand and 
# right-hand sides
form <- formula(outcome ~ treatment + confounder + unit + time)
model_terms(form)
}
