% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{plotdv}
\alias{plotdv}
\title{Plot Double Vertical Spread}
\usage{
plotdv(s, x1, x2, x3, x4, t, r, sigma, sigma2 = sigma, sigma3 = sigma,
  sigma4 = sigma, d = 0, ll = 0.75, ul = 1.25, xlab = "spot",
  ylab = "Profit/Loss", main = "Double Vertical Spread")
}
\arguments{
\item{s}{Spot price of the underlying asset}

\item{x1}{Lower-strike put option price (long option)}

\item{x2}{Higher-strike put option price (short option)}

\item{x3}{Lower-strike call option price (short option)}

\item{x4}{Higher-strike call option price (long option)}

\item{t}{Time to expiration in years}

\item{r}{Annual continuously compounded risk-free rate}

\item{sigma}{Annualized implied volatility of the lower-strike put option}

\item{sigma2}{Annualized implied volatility of the higher-strike put option}

\item{sigma3}{Annualized implied volatility of the lower-strike call option}

\item{sigma4}{Annualized implied volatility of the higher-strike call option}

\item{d}{Annual continuously compounded risk-free rate}

\item{ll}{Lower-limit of the plot, set as (desired price/spot)}

\item{ul}{Upper-limit of the plot, set as (desired price/spot)}

\item{xlab}{X-Axis Label}

\item{ylab}{Y-Axis Label}

\item{main}{Title of the plot}
}
\value{
Returns a plot of a double vertical spread (credit spread).
Black line: The profit(loss) at expiration.
Red line: The profit(loss) at (1/2) time "t" ~ half-way to expiration.
Blue line: The profit(loss) at inception.
}
\description{
Plot a double vertical spread (credit spread)
}
\details{
The double vertical spread consists of a credit put spread and a credit debit spread.
}
\examples{
plotdv(s= 100, x1 = 90, x2 = 95, x3 = 105, x4 = 110, t = (45/365), r = 0.02, sigma = 0.20)
}
\author{
John T. Buynak
}
