% Generated by roxygen2 (4.0.0): do not edit by hand
\name{BTLboost}
\alias{BTLboost}
\title{Boosting ordinal Bradley-Terry-Luce models}
\usage{
BTLboost(formula, data, objects=NULL, groupVars=NULL,
                selection=c("DEVIANCE","AIC","BIC"),
                mstop=500, nu=1, maxit=1, verbose=TRUE, ...)
}
\arguments{
\item{formula}{a formula describing the full model.}

\item{data}{a data frame containing the design matrix for the model
(See also \code{\link{design}} to generate such an design matrix).}

\item{objects}{(optional) a character vector specifying the objects that
should always be part of the model.}

\item{groupVars}{(optional) a character vector specifying the subject-specific
covariates, whose subject-object interactions are considered simultaneously
in each boosting step. By default (\code{groupVars=NULL}), all subject-object
interactions are cosidered separately in each boosting step.}

\item{selection}{a character specifying the criterion that is used in each
boosting step to determine the best fitting covariate(s).}

\item{mstop}{an integer giving the number of boosting iterations.}

\item{nu}{a double between 0 and 1 defining the step size or shrinkage parameter.}

\item{maxit}{an integer representing the maximum number of Fisher-scoring iterations (see also \code{\link[VGAM]{vglm.control}}).}

\item{verbose}{logical indicating if output should be produced for each boosting iteration.}

\item{...}{further arguments passed to \code{ordBTL}.}
}
\value{
A List of \itemize{
\item \code{BEST} contains estimated parameters of the last boosting iteration
\item \code{AIC} a vector of AIC values for each boosting iteration
\item \code{BIC} a vector of BIC values for each boosting iteration
\item \code{DEVIANCE} a vector that reflects the deviance of each boosting iteration
\item \code{PATH} a dataframe containing the coefficient build-up at the end of each boosting iteration
\item \code{UPDATED} a vector of strings containing the selected components in each boosting iteration
}
}
\description{
Boosting procedure for ordinal BTL models
}
\examples{
# Get the CEMS data and generate design matrix
example(wide2long, package="ordBTL", echo=FALSE)

des2 <- design(CEMSlong[-which(is.na(CEMSlong$Y)),], 
               var1="object1", var2="object2", 
               use.vars="ALL", reference="Stockholm")

# Formula for full model considering all subject-object interactions
form2 <- Y ~ 
  (GAMMA.London+GAMMA.Paris+GAMMA.Milano+GAMMA.StGallen+GAMMA.Barcelona)+
  (GAMMA.London+GAMMA.Paris+GAMMA.Milano+GAMMA.StGallen+GAMMA.Barcelona):
  (WOR+SEX+DEG+STUD+ENG+FRA+SPA+ITA)

## Not run: 
# Exemplatory boosting call with mstop=5
#BoostDev <- BTLboost(form2, data=des2, groupVars=c("WOR","DEG","SEX","STUD"), 
#                     selection="DEVIANCE", mstop=5)
## End(Not run)
}
\author{
Giuseppe Casalicchio
}

