% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recipe_commit.R
\name{orderly_commit}
\alias{orderly_commit}
\title{Commit a generated report}
\usage{
orderly_commit(id, name = NULL, root = NULL, locate = TRUE, timeout = 10)
}
\arguments{
\item{id}{The identifier of the report}

\item{name}{The name of the report - this can be omitted and the
name will be determined from the \code{id}.}

\item{root}{The path to an orderly root directory, or \code{NULL}
(the default) to search for one from the current working
directory if \code{locate} is \code{TRUE}.}

\item{locate}{Logical, indicating if the configuration should be
searched for.  If \code{TRUE} and \code{config} is not given,
then orderly looks in the working directory and up through its
parents until it finds an \code{orderly_config.yml} file.}

\item{timeout}{Time in seconds to wait for db to be available. In
parallel the database may become locked so we can choose to wait
for \code{timeout} seconds before throwing an error.}
}
\value{
The path to the newly committed report
}
\description{
Commit a generated report, moving it from the \code{draft/}
directory to \code{archive/} and updating the orderly index.  Once
committed, reports should not be deleted.
}
\examples{
# In a new example orderly, run a report
path <- orderly::orderly_example("minimal")
id <- orderly::orderly_run("example", root = path)

# To commit it, all we need is the report id
orderly::orderly_commit(id, root = path)

# The report is now committed, and as such could be used as a
# dependency in another report and is not subject to deletion by
# orderly::orderly_cleanup
orderly::orderly_list_archive(root = path)
}
