% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/info.R
\name{orderly_info}
\alias{orderly_info}
\title{Return info about a report which has been run}
\usage{
orderly_info(id, name, root = NULL, locate = TRUE)
}
\arguments{
\item{id}{The report ID}

\item{name}{The name of the report}

\item{root}{The path to an orderly root directory, or \code{NULL}
(the default) to search for one from the current working
directory if \code{locate} is \code{TRUE}.}

\item{locate}{Logical, indicating if the configuration should be
searched for.  If \code{TRUE} and \code{config} is not given,
then orderly looks in the working directory and up through its
parents until it finds an \code{orderly_config.yml} file.}
}
\value{
Info from report run - this is subject to change. Returns a list
which includes report id, name, indication of success, run date and
elapsed time, parameters, git info (if available), path to logfile
(if exists) and details of error if the run failed
}
\description{
This will return info from either successful or failed reports. It will
look for the report with `id` in archive first and then look in drafts
if it can't be found from archive.
}
\examples{
path <- orderly::orderly_example("demo")
id <- orderly::orderly_run("minimal", root = path)
orderly::orderly_info(id, "minimal", root = path)
}
