% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ordinalNet-methods.R
\name{coef.ordinalNet}
\alias{coef.ordinalNet}
\title{Method to extract fitted coefficients from an "ordinalNet" object.}
\usage{
\method{coef}{ordinalNet}(
  object,
  matrix = FALSE,
  whichLambda = NULL,
  criteria = c("aic", "bic"),
  ...
)
}
\arguments{
\item{object}{An "ordinalNet" S3 object.}

\item{matrix}{Logical. If \code{TRUE}, coefficient estimates are returned in
matrix form. Otherwise a vector is returned.}

\item{whichLambda}{Optional index number of the desired \code{lambda} within
the sequence of \code{lambdaVals}. By default, the solution with the best AIC
is returned.}

\item{criteria}{Selects the best \code{lambda} value by AIC or BIC. Only used
if \code{whichLambda=NULL}.}

\item{...}{Not used. Additional coef arguments.}
}
\value{
The object returned depends on \code{matrix}.
}
\description{
Method to extract fitted coefficients from an "ordinalNet" object.
}
\examples{
# See ordinalNet() documentation for examples.

}
\seealso{
\code{\link{ordinalNet}}
}
