% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xyzt_units.R, R/zzz_niftiImage.R
\docType{methods}
\name{xyzt_units-methods}
\alias{xyzt_units-methods}
\alias{xyzt_units-methods,}
\alias{xyzt_units}
\alias{xyzt_units,nifti-method}
\alias{xyzt_units<-}
\alias{xyzt_units<-,nifti-method}
\alias{xyzt.units}
\alias{xyzt.units,nifti-method}
\alias{xyzt.units<-}
\alias{xyzt.units<-,nifti-method}
\alias{xyzt_units,niftiImage-method}
\alias{xyzt_units<-,niftiImage-method}
\title{Extract Image Attribute \code{xyzt_units}}
\usage{
xyzt_units(object)

\S4method{xyzt_units}{nifti}(object)

xyzt_units(object) <- value

\S4method{xyzt_units}{nifti}(object) <- value

xyzt.units(object)

\S4method{xyzt.units}{nifti}(object)

xyzt.units(object) <- value

\S4method{xyzt.units}{nifti}(object) <- value

\S4method{xyzt_units}{niftiImage}(object)

\S4method{xyzt_units}{niftiImage}(object) <- value
}
\arguments{
\item{object}{is an object of class \code{nifti} or \code{anlz}.}

\item{value}{is the value to assign to the \code{xyzt_units} field.}
}
\description{
Methods that act on the \code{xyzt_units} field in the
NIfTI/ANALYZE header.
}
\details{
See documentation on the ANALYZE and/or NIfTI data standards for
more details.
}
\examples{
file = system.file("extdata", "example.nii.gz", package = "RNifti")
img = RNifti::readNifti(file)
xyzt_units(img)
xyzt_units(img) = 8
stopifnot(xyzt_units(img) ==  8)
}
\references{
ANALYZE 7.5\cr
\url{http://eeg.sourceforge.net/ANALYZE75.pdf}\cr
NIfTI-1\cr
\url{http://nifti.nimh.nih.gov/}
}
\author{
John Muschelli \email{muschellij2@gmail.com},\cr
Brandon Whitcher \email{bwhitcher@gmail.com}
}
