% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slice_overlay.R
\docType{methods}
\name{slice_overlay-methods}
\alias{slice_overlay-methods}
\alias{slice_overlay.nifti}
\alias{slice_overlay}
\alias{slice_overlay,nifti,nifti-method}
\alias{slice_overlay,nifti,anlz-method}
\alias{slice_overlay,nifti,array-method}
\alias{slice_overlay,anlz,nifti-method}
\alias{slice_overlay,anlz,anlz-method}
\alias{slice_overlay,anlz,array-method}
\alias{slice_overlay,array,nifti-method}
\alias{slice_overlay,array,anlz-method}
\alias{slice_overlay,array,array-method}
\alias{slice_overlay,afni,afni-method}
\alias{slice_overlay,afni,array-method}
\alias{slice_overlay,nifti,missing-method}
\title{Methods for Function slice_overlay}
\usage{
slice_overlay.nifti(
  x,
  y,
  z = 1,
  w = 1,
  col.x = gray(0:64/64),
  col.y = hotmetal(),
  zlim.x = NULL,
  zlim.y = NULL,
  plane = c("axial", "coronal", "sagittal"),
  xlab = "",
  ylab = "",
  axes = FALSE,
  oma = rep(0, 4),
  mar = rep(0, 4),
  bg = "black",
  NA.x = FALSE,
  NA.y = TRUE,
  useRaster = TRUE,
  ...
)

slice_overlay(x, y, ...)

\S4method{slice_overlay}{nifti,missing}(
  x,
  y,
  z = 1,
  w = 1,
  col.x = gray(0:64/64),
  col.y = hotmetal(),
  zlim.x = NULL,
  zlim.y = NULL,
  plane = c("axial", "coronal", "sagittal"),
  xlab = "",
  ylab = "",
  axes = FALSE,
  oma = rep(0, 4),
  mar = rep(0, 4),
  bg = "black",
  NA.x = FALSE,
  NA.y = TRUE,
  useRaster = TRUE,
  ...
)

\S4method{slice_overlay}{nifti,nifti}(
  x,
  y,
  z = 1,
  w = 1,
  col.x = gray(0:64/64),
  col.y = hotmetal(),
  zlim.x = NULL,
  zlim.y = NULL,
  plane = c("axial", "coronal", "sagittal"),
  xlab = "",
  ylab = "",
  axes = FALSE,
  oma = rep(0, 4),
  mar = rep(0, 4),
  bg = "black",
  NA.x = FALSE,
  NA.y = TRUE,
  useRaster = TRUE,
  ...
)

\S4method{slice_overlay}{anlz,anlz}(
  x,
  y,
  z = 1,
  w = 1,
  col.x = gray(0:64/64),
  col.y = hotmetal(),
  zlim.x = NULL,
  zlim.y = NULL,
  plane = c("axial", "coronal", "sagittal"),
  xlab = "",
  ylab = "",
  axes = FALSE,
  oma = rep(0, 4),
  mar = rep(0, 4),
  bg = "black",
  NA.x = FALSE,
  NA.y = TRUE,
  useRaster = TRUE,
  ...
)

\S4method{slice_overlay}{anlz,nifti}(
  x,
  y,
  z = 1,
  w = 1,
  col.x = gray(0:64/64),
  col.y = hotmetal(),
  zlim.x = NULL,
  zlim.y = NULL,
  plane = c("axial", "coronal", "sagittal"),
  xlab = "",
  ylab = "",
  axes = FALSE,
  oma = rep(0, 4),
  mar = rep(0, 4),
  bg = "black",
  NA.x = FALSE,
  NA.y = TRUE,
  useRaster = TRUE,
  ...
)

\S4method{slice_overlay}{nifti,anlz}(
  x,
  y,
  z = 1,
  w = 1,
  col.x = gray(0:64/64),
  col.y = hotmetal(),
  zlim.x = NULL,
  zlim.y = NULL,
  plane = c("axial", "coronal", "sagittal"),
  xlab = "",
  ylab = "",
  axes = FALSE,
  oma = rep(0, 4),
  mar = rep(0, 4),
  bg = "black",
  NA.x = FALSE,
  NA.y = TRUE,
  useRaster = TRUE,
  ...
)

\S4method{slice_overlay}{array,array}(x, y, ...)

\S4method{slice_overlay}{array,nifti}(x, y, ...)

\S4method{slice_overlay}{nifti,array}(x, y, ...)

\S4method{slice_overlay}{array,anlz}(x, y, ...)

\S4method{slice_overlay}{anlz,array}(x, y, ...)

\S4method{slice_overlay}{afni,afni}(x, y, ...)

\S4method{slice_overlay}{afni,array}(x, y, ...)
}
\arguments{
\item{x, y}{is an object of class \code{nifti} or similar.}

\item{z}{is the slice to be displayed (ignored when \code{plot.type =
"multiple"}).}

\item{w}{is the time point to be displayed (4D arrays only).}

\item{col.x}{is grayscale (by default).}

\item{col.y}{is hotmetal (by default).}

\item{zlim.x, zlim.y}{are set to \code{NULL} (by default) and taken from the
header information.}

\item{plane}{is the plane of acquisition to be displayed (choices are
\sQuote{axial}, \sQuote{coronal}, \sQuote{sagittal}).}

\item{xlab}{is set to \dQuote{} since all margins are set to zero.}

\item{ylab}{is set to \dQuote{} since all margins are set to zero.}

\item{axes}{is set to \code{FALSE} since all margins are set to zero.}

\item{oma}{is the size of the outer margins in the \code{par} function.}

\item{mar}{is the number of lines of margin in the \code{par} function.}

\item{bg}{is the background color in the \code{par} function.}

\item{NA.x}{Set any values of 0 in \code{x} to \code{NA}}

\item{NA.y}{Set any values of 0 in \code{y} to \code{NA}}

\item{useRaster}{if \code{TRUE}, a bitmap raster is used to plot 
the image instead of polygons. Passed to \code{\link[graphics]{image}}}

\item{\dots}{other arguments to the \code{image} function may be provided
here.}
}
\description{
Methods for function \code{slice_overlay}
}
\details{
The \code{image} command is used multiple times to simultaneously visualize
one of the three orthogonal planes in two multidimensional arrays, one on
top of the other, for medical imaging data.
}
\section{Methods}{
 
\describe{ 
\item{x = "nifti", y = "nifti"}{Produce slice_overlay of \code{y} on \code{x}.} 
\item{x = "anlz", y = "anlz"}{Produce slice_overlay of \code{y} on \code{x}.} 
\item{x = "afni", y = "afni"}{Produce slice_overlay of \code{y} on \code{x}.} 
}
}

\seealso{
\code{\link{image-methods}}, \code{\link{slice_overlay-methods}}
}
\author{
Brandon Whitcher \email{bwhitcher@gmail.com}
}
\keyword{methods}
