% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parseRec.R
\name{mapTrees}
\alias{mapTrees}
\title{Map Gene Tree into Species Tree}
\usage{
mapTrees(path2rec)
}
\arguments{
\item{path2rec}{path to the file containing the reconciliation output.}
}
\value{
A list with three elements. The first one is a 'phylo' object where the nodelabels indicate the event: D, duplication or T transfer. If no label is shown is because the event correspond to speciation. The second element is a dataframe (the first column is the label of the internal nodes in the gene tree; the second column is the label of the internal nodes in the species tree, and the third and fourth columns label each internal node according to the inferred event). The third element of the list is an adjacency matrix: 1 when two proteins are orthologous, 0 if they are paralogous.
}
\description{
Maps a gene/protein tree into a species tree
}
\details{
Mapping gene tree into species tree allow to infer the sequence of events (Duplication, Speciation, Transfer).
}
\examples{
mapTrees(fs::path_package("extdata", "representatives", package = "orthGS"))
}
