% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel_weight.r
\name{kernel_weight}
\alias{kernel_weight}
\title{kernel_weight}
\usage{
kernel_weight(x1, x2, kernel = "gaussian", dist = "euclidean")
}
\arguments{
\item{x1}{first data matrix}

\item{x2}{second data matrix}

\item{kernel}{the kernel function, currently only using Gaussian kernel}

\item{dist}{the distance metric, currently only using the Euclidean distance}
}
\value{
A distance matrix, with its (i, j)th element being the kernel weights for the ith row of \code{X1} jth row of \code{X2}.
}
\description{
Calculate the Gaussian kernel weights between rows of X1 and rows of X2
}
\examples{
# two matrices
set.seed(1)
x1 = matrix(rnorm(10), 5, 2)
x2 = matrix(rnorm(6), 3, 2)
kernel_weight(x1, x2)
}
