% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osf_ls_nodes.R
\name{osf_ls_nodes}
\alias{osf_ls_nodes}
\title{List projects or components on OSF}
\usage{
osf_ls_nodes(x, pattern = NULL, n_max = 10, verbose = FALSE)
}
\arguments{
\item{x}{one of the following:
\itemize{
\item An \code{\link{osf_tbl_node}} with a single project or component.
\item An \code{\link{osf_tbl_user}} with a single OSF user.
}}

\item{pattern}{Character string used to filter for results that contain the
substring \code{"pattern"} in their name. \emph{Note:} this is a fixed, case-insensitive
search.}

\item{n_max}{Maximum number of results to return from OSF (default is 10).
Set to \code{Inf} to return \emph{all} results.}

\item{verbose}{Logical, indicating whether to print informative messages
about interactions with the OSF API (default \code{FALSE}).}
}
\value{
An \code{\link{osf_tbl_node}} with one row for each OSF project or component,
ordered by modification time.
}
\description{
List the projects or components associated with a user or contained in the
top-level of another OSF project or component.
}
\examples{
\dontrun{
# List your recent projects and components
osf_retrieve_user("me") \%>\%
  osf_ls_nodes()

# List the first 10 components in the #ScanAllFish project
fish_ctscans <- osf_retrieve_node("ecmz4")
osf_ls_nodes(fish_ctscans)

# Now just the components with scans of species from the Sphyrna genus
osf_ls_nodes(fish_ctscans, pattern = "Sphyrna")
}
}
\seealso{
\code{\link[=osf_ls_files]{osf_ls_files()}} to generate a list of files and files.
}
