% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osmapi_changesets.R
\name{osm_diff_upload_changeset}
\alias{osm_diff_upload_changeset}
\title{Diff (OsmChange format) upload to a changeset}
\usage{
osm_diff_upload_changeset(changeset_id, osmcha, format = c("R", "xml"))
}
\arguments{
\item{changeset_id}{The ID of the changeset this diff belongs to. The user issuing this API call has to be the same
that created the changeset.}

\item{osmcha}{The OsmChange data. Can be the path of an OsmChange file, a \link[xml2:oldclass]{xml2::xml_document} or an
\code{osmapi_OsmChange} object (see \verb{osmchange_*()} functions).}

\item{format}{Format of the output. Can be \code{"R"} (default) or \code{"xml"}.}
}
\value{
If a diff is successfully applied and \code{format = "R"}, it returns a data frame with one row for each edited object.
For \code{format = "xml"}, a \link[xml2:oldclass]{xml2::xml_document} is returned in the following format:

\if{html}{\out{<div class="sourceCode xml">}}\preformatted{<diffResult generator="OpenStreetMap Server" version="0.6">
	<node|way|relation old_id="#" new_id="#" new_version="#"/>
	...
</diffResult>
}\if{html}{\out{</div>}}

with one element for every object in the upload.

Note that this can be counter-intuitive when the same element has appeared multiple times in the input then it will
appear multiple times in the output.\tabular{lccc}{
   \strong{Attribute} \tab \strong{create} \tab \strong{modify} \tab \strong{delete} \cr
   \strong{old_id} \tab same as uploaded element \tab same as uploaded element \tab same as uploaded element \cr
   \strong{new_id} \tab new ID \tab new ID ''or'' same as uploaded \tab not present \cr
   \strong{new_version} \tab new version \tab new version \tab not present \cr
}
}
\description{
With this API call files in the \href{https://wiki.openstreetmap.org/wiki/OsmChange}{OsmChange} format can be uploaded to
the server. This is guaranteed to be running in a transaction. So either all the changes are applied or none.
}
\details{
To upload an OSC file it has to conform to the \href{https://wiki.openstreetmap.org/wiki/OsmChange}{OsmChange}
specification with the following differences:
\itemize{
\item each element must carry a \code{changeset} and a \code{version} attribute (xml) / column (data.frame), except when you are
creating an element where the version is not required as the server sets that for you. The \code{changeset} must be the
same as the changeset ID being uploaded to.
\item a \verb{<delete>} block in the OsmChange document may have an \verb{if-unused} attribute (the value of which is ignored)
(\code{action_type} column with \verb{delete if-unused} for data.frames). If this attribute is present, then the delete
operation(s) in this block are conditional and will only be executed if the object to be deleted is not used by
another object. Without the \verb{if-unused}, such a situation would lead to an error, and the whole diff upload would
fail. Setting the attribute will also cause deletions of already deleted objects to not generate an error.
\item \href{https://wiki.openstreetmap.org/wiki/OsmChange}{OsmChange} documents generally have \code{user} and \code{uid} attributes
on each element. These are not required in the document uploaded to the API.
}
}
\note{
\itemize{
\item Processing stops at the first error, so if there are multiple conflicts in one diff upload, only the first problem
is reported.
\item Refer to \code{\link[=osm_capabilities]{osm_capabilities()}} --> \code{changesets$maximum_elements} for the maximum number of changes permitted in a
changeset.
\item There is currently no limit in the diff size on the Rails port. CGImap limits diff size to 50MB (uncompressed
size).
\item Forward referencing of placeholder ids is not permitted and will be rejected by the API.
}
}
\examples{
vignette("how_to_edit_osm", package = "osmapiR")
}
\seealso{
Other edit changeset's functions: 
\code{\link{osm_create_changeset}()}

Other OsmChange's functions: 
\code{\link{osm_download_changeset}()},
\code{\link{osmchange_create}()},
\code{\link{osmchange_delete}()},
\code{\link{osmchange_modify}()}
}
\concept{OsmChange's functions}
\concept{edit changeset's functions}
