% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tags_list-wide.r
\name{tags_list2wide}
\alias{tags_list2wide}
\alias{tags_wide2list}
\title{Change \code{tags} from a list column <-> columns for each key in wide format}
\usage{
tags_list2wide(x)

tags_wide2list(x)
}
\arguments{
\item{x}{An \code{osmapi_objects} or \code{osmapi_changesets} objects as returned by, for example, \code{\link[=osm_get_objects]{osm_get_objects()}} or
\code{\link[=osm_get_changesets]{osm_get_changesets()}}.}
}
\value{
A data frame with the same class and data than the original (\code{osmapi_objects} or \code{osmapi_changesets}) but with the
specified tags' format.
}
\description{
Objects of classes \code{osmapi_objects} and \code{osmapi_changesets} can represent the tags in a column with a list with
a data.frame for each row with 2 columns for keys and values, or by columns for each key. These functions allow
to change the format of the tags.
}
\details{
Both formats have advantages. Tags in a list of data.frames is a more compact representation and there is no risk of
clashes of column names and tag keys. Tags in columns make it easier to select rows by tags as in a regular
data.frame. Column name clashes are resolved and the original key names restored when transformed to tags list
format.

By default, functions returning \code{osmapi_objects} or \code{osmapi_changesets} objects, use the the tags in a list column,
but can return the results in a wide format using the parameter \code{tags_in_columns = TRUE}.
}
\examples{
peaks_wide <- osm_get_objects(
  osm_type = "node", osm_id = c(35308286, 1935675367), tags_in_columns = TRUE
)
peaks_list <- tags_wide2list(peaks_wide)

# tags in list format
peaks_list$tags

# Select peaks with `prominence` tag
peaks_wide[!is.na(peaks_wide$prominence), ]
peaks_list[sapply(peaks_list$tags, function(x) any(x$key == "prominence")), ]

cities_list <- osm_get_objects(osm_type = "relation", osm_id = c("40581", "341530"))
# Column name clash:
cities_wide <- tags_list2wide(cities_list)
}
\seealso{
Other methods: 
\code{\link{st_as_sf}}
}
\concept{methods}
