% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{oe_search}
\alias{oe_search}
\title{Search for a place and return an sf data frame locating it}
\usage{
oe_search(
  place,
  base_url = "https://nominatim.openstreetmap.org",
  destfile = tempfile(fileext = ".geojson"),
  ...
)
}
\arguments{
\item{place}{Text string containing the name of a place the location of
which is to be found, such as \code{"Leeds"} or \code{"Milan"}.}

\item{base_url}{The URL of the nominatim server to use. The main
open server hosted by OpenStreetMap is the default.}

\item{destfile}{The name of the destination file where the output
of the search query, a \code{.geojson} file, should be saved.}

\item{...}{Extra arguments that are passed to \code{sf::st_read}.}
}
\value{
An \code{sf} object corresponding to the input place. The \code{sf} object is
read by \code{sf::st_read()} and it is based on a \code{geojson} file returned by
Nominatim API.
}
\description{
This (at the moment internal) function provides a simple interface to the
\href{https://nominatim.openstreetmap.org}{nominatim} service for finding the
geographical location of place names.
}
