% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{oe_read}
\alias{oe_read}
\title{Read a .pbf or .gpkg object from file or url}
\usage{
oe_read(
  file_path,
  layer = "lines",
  ...,
  provider = NULL,
  download_directory = oe_download_directory(),
  file_size = NULL,
  force_download = FALSE,
  max_file_size = 5e+08,
  download_only = FALSE,
  skip_vectortranslate = FALSE,
  vectortranslate_options = NULL,
  osmconf_ini = NULL,
  extra_tags = NULL,
  force_vectortranslate = FALSE,
  never_skip_vectortranslate = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{file_path}{A URL or the path of a \code{.pbf} or \code{.gpkg} file. If a URL,
then it must be specified using HTTP/HTTPS protocol.}

\item{layer}{Which \code{layer} should be read in? Typically \code{points}, \code{lines}
(the default), \code{multilinestrings}, \code{multipolygons} or \code{other_relations}. If
you specify an ad-hoc query using the argument \code{query} (see introductory
vignette and examples), then \code{oe_get()} and \code{oe_read()} will read the layer
specified in the query and ignore \code{layer}. See also
\href{https://github.com/ropensci/osmextract/issues/122}{#122}.}

\item{...}{Arguments that will be passed to \code{\link[sf:st_read]{sf::st_read()}}, like \code{query},
\code{wkt_filter} or \code{stringsAsFactors}.  Check the introductory vignette to
understand how to create your own (SQL-like) queries.}

\item{provider}{Which provider should be used to download the data? Available
providers can be found with the following command: \code{\link[=oe_providers]{oe_providers()}}. For
\code{\link[=oe_get]{oe_get()}} and \code{\link[=oe_match]{oe_match()}}, if \code{place} is equal to \verb{ITS Leeds}, then
\code{provider} is set equal to \code{test}. This is just for simple examples and
internal tests.}

\item{download_directory}{Where to download the file containing the OSM data?
By default this is equal to \code{\link[=oe_download_directory]{oe_download_directory()}}, which is equal to
\code{\link[=tempdir]{tempdir()}} and it changes each time you restart R. You can set a
persistent \code{download_directory} by adding the following to your \code{.Renviron}
file (e.g. with \code{edit_r_environ} function in \code{usethis} package):
\verb{OSMEXT_DOWNLOAD_DIRECTORY=/path/to/osm/data}.}

\item{file_size}{How big is the file? Optional. \code{NA} by default. If it's
bigger than \code{max_file_size} and the function is run in interactive mode,
then an interactive menu is displayed, asking for permission to download
the file.}

\item{force_download}{Should the \code{.osm.pbf} file be updated if it has already
been downloaded? \code{FALSE} by default. This parameter is used to update old
\code{.osm.pbf} files.}

\item{max_file_size}{The maximum file size to download without asking in
interactive mode. Default: \code{5e+8}, half a gigabyte.}

\item{download_only}{Boolean. If \code{TRUE}, then the function only returns the
path where the matched file is stored, instead of reading it. \code{FALSE} by
default.}

\item{skip_vectortranslate}{Boolean. If \code{TRUE}, then the function skips all
vectortranslate operations and it reads (or simply returns the path) of the
\code{.osm.pbf} file. \code{FALSE} by default.}

\item{vectortranslate_options}{Options passed to the \code{\link[sf:gdal_utils]{sf::gdal_utils()}}
argument \code{options}. Set by default. Check details in the introductory
vignette and the help page of \code{\link[=oe_vectortranslate]{oe_vectortranslate()}}.}

\item{osmconf_ini}{The configuration file. See documentation at
\href{https://gdal.org/drivers/vector/osm.html}{gdal.org}. Check details in the
introductory vignette and the help page of \code{\link[=oe_vectortranslate]{oe_vectortranslate()}}. Set by
default.}

\item{extra_tags}{Which additional columns, corresponding to OSM tags, should
be in the resulting dataset? \code{NULL} by default. Check the introductory
vignette and the help pages of \code{\link[=oe_vectortranslate]{oe_vectortranslate()}} and \code{\link[=oe_get_keys]{oe_get_keys()}}.
Ignored when \code{osmconf_ini} is not \code{NULL}.}

\item{force_vectortranslate}{Boolean. Force the original \code{.pbf} file to be
translated into a \code{.gpkg} file, even if a \code{.gpkg} with the same name
already exists? \code{FALSE} by default. If tags in \code{extra_tags} match data
in previously translated \code{.gpkg} files no translation occurs
(see \href{https://github.com/ropensci/osmextract/issues/173}{#173} for details).
Check the introductory vignette and the help page of
\code{\link[=oe_vectortranslate]{oe_vectortranslate()}}.}

\item{never_skip_vectortranslate}{Boolean. This is used in case the user
passed its own \code{.ini} file or vectortranslate options (since, in those case,
it's too difficult to determine if an existing \code{.gpkg} file was generated
following the same options.)}

\item{quiet}{Boolean. If \code{FALSE}, the function prints informative messages.
Starting from \code{sf} version
\href{https://r-spatial.github.io/sf/news/index.html#version-0-9-6-2020-09-13}{0.9.6},
if \code{quiet} is equal to \code{FALSE}, then vectortranslate operations will
display a progress bar.}
}
\value{
An \code{sf} object.
}
\description{
This function is used to read a \code{.pbf} or \code{.gpkg} object from file or URL. It
is a wrapper around \code{\link[=oe_download]{oe_download()}}, \code{\link[=oe_vectortranslate]{oe_vectortranslate()}}, and
\code{\link[sf:st_read]{sf::st_read()}}, creating an easy way to download, convert, and read a \code{.pbf}
or \code{.gpkg} file. Check the introductory vignette and the help pages of the
wrapped function for more details.
}
\details{
The arguments \code{provider}, \code{download_directory}, \code{file_size},
\code{force_download}, and \code{max_file_size} are ignored if \code{file_path} points to
an existing \code{.pbf} or \code{.gpkg} file.

You cannot add any field or layer to an existing \code{.gpkg} file (unless you
have the \code{.pbf} file and you convert it again with a different
configuration), but you can extract some of the tags in \code{other_tags} field.
Check examples and \code{\link[=oe_get_keys]{oe_get_keys()}} for more details.
}
\examples{
# Read an existing .pbf file. First we need to copy a .pbf file into a
# temporary directory
file.copy(
  from = system.file("its-example.osm.pbf", package = "osmextract"),
  to = file.path(tempdir(), "its-example.osm.pbf")
)
my_pbf = file.path(tempdir(), "its-example.osm.pbf")
oe_read(my_pbf)
oe_read(my_pbf, layer = "points") # Read a new layer
# The following example shows how to add new tags
names(oe_read(my_pbf, extra_tags = c("oneway", "ref"), quiet = FALSE))

# Read an existing .gpkg file. This file was created by oe_read
my_gpkg = file.path(tempdir(), "its-example.gpkg")
oe_read(my_gpkg)
# You cannot add any layer to an existing .gpkg file but you can extract some
# of the tags in other_tags. Check oe_get_keys() for more details.
names(oe_read(my_gpkg, extra_tags = c("maxspeed"))) # doesn't work
# Instead, use the query argument
names(oe_read(
  my_gpkg,
  quiet = TRUE,
  query =
  "SELECT *,
  hstore_get_value(other_tags, 'maxspeed') AS maxspeed
  FROM lines
  "
))

# Read from a URL
my_url = "https://github.com/ropensci/osmextract/raw/master/inst/its-example.osm.pbf"
# Please note that if you read from a URL which is not linked to one of the
# supported providers, you need to specify the provider parameter:
\dontrun{
oe_read(my_url, provider = "test", quiet = FALSE)
}
}
