/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.grid;

import fr.ird.osmose.Cell;
import fr.ird.osmose.grid.AbstractGrid;
import java.io.IOException;
import ucar.nc2.NetcdfFile;

public class ECO3MGrid
extends AbstractGrid {
    private String gridFile;
    private String strLon;
    private String strLat;
    private String strMask;
    private int stride;

    @Override
    public void readParameters() {
        this.gridFile = this.getConfiguration().getFile("grid.netcdf.file");
        this.strLat = this.getConfiguration().getString("grid.var.lat");
        this.strLon = this.getConfiguration().getString("grid.var.lon");
        this.strMask = this.getConfiguration().getString("grid.var.mask");
        this.stride = this.getConfiguration().getInt("grid.stride");
    }

    private NetcdfFile openNetcdfFile(String gridFile) {
        try {
            return NetcdfFile.open(gridFile, null);
        }
        catch (IOException ex) {
            this.error("Failed to open NetCDF grid file " + gridFile, ex);
            return null;
        }
    }

    private double[][] readVariable(NetcdfFile nc, String varname) {
        try {
            return (double[][])nc.findVariable(varname).read().copyToNDJavaArray();
        }
        catch (IOException ex) {
            this.error("Error while reading variable " + varname + " in NetCDF grid file " + nc.getLocation(), ex);
            return null;
        }
    }

    private double[][] eco3m2osmose(double[][] eco3mvar, int stride) {
        int jmstr = eco3mvar.length / stride;
        int imstr = eco3mvar[0].length / stride;
        double[][] osmosevar = new double[jmstr][imstr];
        for (int i = 0; i < imstr; ++i) {
            for (int j = 0; j < jmstr; ++j) {
                for (int ii = 0; ii < stride; ++ii) {
                    for (int jj = 0; jj < stride; ++jj) {
                        double[] dArray = osmosevar[j];
                        int n = i;
                        dArray[n] = dArray[n] + eco3mvar[j * stride + jj][i * stride + ii] / (double)(stride * stride);
                    }
                }
            }
        }
        return osmosevar;
    }

    @Override
    Cell[][] makeGrid() {
        NetcdfFile ncGrid = this.openNetcdfFile(this.gridFile);
        double[][] lon = this.eco3m2osmose(this.readVariable(ncGrid, this.strLon), this.stride);
        double[][] lat = this.eco3m2osmose(this.readVariable(ncGrid, this.strLat), this.stride);
        double[][] mask = this.readVariable(ncGrid, this.strMask);
        int jmstr = lon.length;
        int imstr = lon[0].length;
        Cell[][] grid = new Cell[jmstr][imstr];
        for (int i = 0; i < imstr; ++i) {
            for (int j = 0; j < jmstr; ++j) {
                float fmask = 0.0f;
                for (int ii = 0; ii < this.stride; ++ii) {
                    for (int jj = 0; jj < this.stride; ++jj) {
                        fmask = (float)((double)fmask + mask[j * this.stride + jj][i * this.stride + ii]);
                    }
                }
                boolean land = (double)(fmask /= (float)(this.stride * this.stride)) <= 0.5;
                grid[j][i] = new Cell(j * imstr + i, i, j, (float)lat[j][i], (float)lon[j][i], land);
            }
        }
        return grid;
    }
}

