/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.ltl;

import fr.ird.osmose.ltl.AbstractLTLForcing;
import java.io.IOException;
import java.util.ArrayList;
import ucar.ma2.ArrayDouble;
import ucar.nc2.NetcdfFile;

public class LTLForcingECO3M
extends AbstractLTLForcing {
    private String[] planktonFileListNetcdf;
    private String zlevelName;
    private float[][][] depthOfLayer;
    private String[] plktonNetcdfNames;
    private int stride;

    public LTLForcingECO3M(int rank) {
        super(rank);
    }

    @Override
    public void readParameters() {
        int i;
        this.plktonNetcdfNames = new String[this.getConfiguration().getNPlankton()];
        for (i = 0; i < this.getConfiguration().getNPlankton(); ++i) {
            this.plktonNetcdfNames[i] = this.getConfiguration().getString("ltl.netcdf.var.plankton.plk" + i);
        }
        this.planktonFileListNetcdf = new String[this.getConfiguration().findKeys("ltl.netcdf.file.t*").size()];
        for (i = 0; i < this.planktonFileListNetcdf.length; ++i) {
            this.planktonFileListNetcdf[i] = this.getConfiguration().getFile("ltl.netcdf.file.t" + i);
        }
        this.zlevelName = this.getConfiguration().getString("ltl.netcdf.var.zlevel");
        this.stride = this.getConfiguration().getInt("grid.stride");
    }

    @Override
    public void initLTLGrid() {
        try {
            String gridFilename = this.planktonFileListNetcdf[0];
            NetcdfFile ncGrid = NetcdfFile.open(gridFilename, null);
            int[] shape = ncGrid.findVariable(this.zlevelName).getShape();
            int nz = shape[0];
            int ny = shape[1];
            int nx = shape[2];
            this.depthOfLayer = new float[nz][ny][nx];
            ArrayDouble.D3 arrDepth = (ArrayDouble.D3)ncGrid.findVariable(this.zlevelName).read();
            for (int i = 0; i < nx; ++i) {
                for (int j = 0; j < ny; ++j) {
                    for (int z = 0; z < nz; ++z) {
                        this.depthOfLayer[z][j][i] = (float)arrDepth.get(z, j, i);
                    }
                }
            }
            ncGrid.close();
            this.icoordLTLGrid = new ArrayList[this.getGrid().get_ny()][this.getGrid().get_nx()];
            this.jcoordLTLGrid = new ArrayList[this.getGrid().get_ny()][this.getGrid().get_nx()];
            for (int j = 0; j < this.getGrid().get_ny(); ++j) {
                for (int i = 0; i < this.getGrid().get_nx(); ++i) {
                    for (int ii = 0; ii < this.stride; ++ii) {
                        for (int jj = 0; jj < this.stride; ++jj) {
                            if (null == this.icoordLTLGrid[j][i]) {
                                this.icoordLTLGrid[j][i] = new ArrayList();
                                this.jcoordLTLGrid[j][i] = new ArrayList();
                            }
                            this.icoordLTLGrid[j][i].add(i * this.stride + jj);
                            this.jcoordLTLGrid[j][i].add(j * this.stride + ii);
                        }
                    }
                }
            }
        }
        catch (IOException ex) {
            this.error("Error while reading the LTL grid", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    double[][] getRawBiomass(int iPlankton, int iStepSimu) {
        float[][][] dataInit = null;
        NetcdfFile nc = null;
        String name = this.planktonFileListNetcdf[this.getIndexStepLTL(iStepSimu)];
        try {
            nc = NetcdfFile.open(name);
            if (null == nc.findVariable(this.plktonNetcdfNames[iPlankton])) {
                this.warning("Osmose could not find LTL variable " + this.plktonNetcdfNames[iPlankton] + " in NetCDF file " + name + ". Unless this plankton group is of type uniform, Osmose might not work correctly.");
                double[][] dArray = new double[0][0];
                return dArray;
            }
            ArrayDouble.D3 tempArray = (ArrayDouble.D3)nc.findVariable(this.plktonNetcdfNames[iPlankton]).read();
            int[] shape = tempArray.getShape();
            dataInit = new float[shape[0]][shape[1]][shape[2]];
            for (int i = 0; i < shape[2]; ++i) {
                for (int j = 0; j < shape[1]; ++j) {
                    for (int k = 0; k < shape[0]; ++k) {
                        dataInit[k][j][i] = (float)tempArray.get(k, j, i);
                    }
                }
            }
        }
        catch (IOException e) {
            this.error("Error reading variable " + this.plktonNetcdfNames[iPlankton] + " from file " + name, e);
        }
        finally {
            if (nc != null) {
                try {
                    nc.close();
                }
                catch (IOException iOException) {}
            }
        }
        return this.verticalIntegration(dataInit, this.depthOfLayer, this.getConfiguration().getFloat("ltl.integration.depth"));
    }
}

