/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.ui;

import fr.ird.osmose.Osmose;
import fr.ird.osmose.grid.IGrid;
import fr.ird.osmose.util.GridMap;
import fr.ird.osmose.util.MapSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class SpatialMapUI
extends JPanel {
    private static int hi;
    private static int wi;
    private static double latmin;
    private static double latmax;
    private static double lonmin;
    private static double lonmax;
    private static BufferedImage background;
    private static RenderingHints hints;
    private static final double ONE_DEG_LATITUDE_IN_METER = 111138.0;
    private int height = 800;
    private int width = 600;
    private boolean isGridVisible = false;
    private static GridMap map;
    private static final int species = 2;

    public SpatialMapUI() {
        hi = -1;
        wi = -1;
        hints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
    }

    @Override
    public void paintComponent(Graphics g) {
        int h = this.getHeight();
        int w = this.getWidth();
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHints(hints);
        g2.clearRect(0, 0, w, h);
        if (hi != h || wi != w) {
            this.drawBackground(g2, w, h);
            hi = h;
            wi = w;
        }
        g2.drawImage((Image)background, 0, 0, this);
    }

    private void drawBackground(Graphics2D g2, int w, int h) {
        background = g2.getDeviceConfiguration().createCompatibleImage(w, h);
        Graphics2D graphic = background.createGraphics();
        graphic.setColor(new Color(223, 212, 200));
        graphic.fillRect(0, 0, w, h);
        CellUI cell = new CellUI();
        int j = SpatialMapUI.getGrid().get_ny() - 1;
        while (j-- > 0) {
            int i = SpatialMapUI.getGrid().get_nx() - 1;
            while (i-- > 0) {
                cell.draw(i, j, w, h);
                graphic.setColor(cell.getColor(i, j));
                graphic.fillPolygon(cell);
                if (!this.isGridVisible) continue;
                graphic.setColor(Color.LIGHT_GRAY);
                graphic.drawPolygon(cell);
            }
        }
    }

    public void setGridVisible(boolean visible) {
        this.isGridVisible = visible;
        this.repaintBackground();
    }

    public void repaintBackground() {
        hi = -1;
        wi = -1;
        this.repaint();
    }

    private int[] grid2Screen(double xgrid, double ygrid, int w, int h) {
        int[] point = new int[2];
        int igrid = (int)xgrid;
        int jgrid = (int)ygrid;
        double dx = xgrid - (double)igrid;
        double dy = ygrid - (double)jgrid;
        double[] p1 = this.grid2Screen(igrid, jgrid, w, h);
        double[] p2 = this.grid2Screen(igrid + 1, jgrid, w, h);
        double[] p3 = this.grid2Screen(igrid, jgrid + 1, w, h);
        double[] p4 = this.grid2Screen(igrid + 1, jgrid + 1, w, h);
        for (int n = 0; n < 2; ++n) {
            double interp = (1.0 - dx) * (1.0 - dy) * p1[n] + dx * (1.0 - dy) * p2[n] + (1.0 - dx) * dy * p3[n] + dx * dy * p4[n];
            point[n] = Double.isNaN(interp) ? -1 : (int)interp;
        }
        return point;
    }

    private double[] grid2Screen(int igrid, int jgrid, int w, int h) {
        double[] point = new double[]{(double)w * (((double)SpatialMapUI.getGrid().getCell(igrid, jgrid).getLon() - lonmin) / Math.abs(lonmax - lonmin)), (double)h * (1.0 - ((double)SpatialMapUI.getGrid().getCell(igrid, jgrid).getLat() - latmin) / Math.abs(latmax - latmin))};
        return point;
    }

    public void init() {
        latmin = SpatialMapUI.getGrid().getLatMin();
        latmax = SpatialMapUI.getGrid().getLatMax();
        lonmin = SpatialMapUI.getGrid().getLongMin();
        lonmax = SpatialMapUI.getGrid().getLongMax();
        double avgLat = 0.5 * (latmin + latmax);
        double dlon = Math.abs(lonmax - lonmin) * 111138.0 * Math.cos(Math.PI * avgLat / 180.0);
        double dlat = Math.abs(latmax - latmin) * 111138.0;
        double ratio = dlon / dlat;
        this.width = (int)((double)this.height * ratio);
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public static double geodesicDistance(double lat1, double lon1, double lat2, double lon2) {
        double lat1_rad = Math.PI * lat1 / 180.0;
        double lat2_rad = Math.PI * lat2 / 180.0;
        double lon1_rad = Math.PI * lon1 / 180.0;
        double lon2_rad = Math.PI * lon2 / 180.0;
        double d = 1.2734E7 * Math.asin(Math.sqrt(Math.pow(Math.sin((lat2_rad - lat1_rad) / 2.0), 2.0) + Math.cos(lat1_rad) * Math.cos(lat2_rad) * Math.pow(Math.sin((lon2_rad - lon1_rad) / 2.0), 2.0)));
        return d;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    public static IGrid getGrid() {
        return Osmose.getInstance().getGrid();
    }

    public static Osmose getOsmose() {
        return Osmose.getInstance();
    }

    private boolean isInMap(int i, int j) {
        return map.getValue(i, j) > 0.0f;
    }

    private static void getCellSize(int i, int j) {
        double lat1 = SpatialMapUI.getGrid().getCell(i, j).getLat();
        double lon1 = SpatialMapUI.getGrid().getCell(i, j).getLon();
        double lat2 = SpatialMapUI.getGrid().getCell(i, j + 1).getLat();
        double lon2 = SpatialMapUI.getGrid().getCell(i, j + 1).getLon();
        double gd = SpatialMapUI.geodesicDistance(lat1, lon1, lat2, lon2);
        System.out.println("gd1: " + gd + " meters");
        lat1 = SpatialMapUI.getGrid().getCell(i, j).getLat();
        lon1 = SpatialMapUI.getGrid().getCell(i, j).getLon();
        lat2 = SpatialMapUI.getGrid().getCell(i + 1, j).getLat();
        lon2 = SpatialMapUI.getGrid().getCell(i + 1, j).getLon();
        gd = SpatialMapUI.geodesicDistance(lat1, lon1, lat2, lon2);
        System.out.println("gd2: " + gd + " meters");
    }

    public static void main(String[] args) {
        SpatialMapUI.getOsmose().readArgs(args);
        SpatialMapUI.getOsmose().init();
        SpatialMapUI.getOsmose().getSimulation(0).init();
        MapSet maps = new MapSet(0, 2, "movement");
        maps.init();
        for (int iMap = 0; iMap < maps.getNMap(); ++iMap) {
            map = maps.getMap(iMap);
            SpatialMapUI grid = new SpatialMapUI();
            grid.init();
            grid.setGridVisible(true);
            StringBuilder title = new StringBuilder();
            title.append(SpatialMapUI.getOsmose().getSimulation(0).getSpecies(2).getName());
            title.append(" map ");
            title.append(maps.getMapFile(iMap));
            JFrame frame = new JFrame(title.toString());
            frame.setDefaultCloseOperation(3);
            JScrollPane scrollPane = new JScrollPane();
            scrollPane.setViewportView(grid);
            frame.getContentPane().add((Component)scrollPane, "Center");
            frame.setExtendedState(6);
            scrollPane.setPreferredSize(grid.getSize());
            scrollPane.revalidate();
            frame.pack();
            frame.setLocationRelativeTo(null);
            frame.setVisible(true);
        }
    }

    static {
        hints = null;
    }

    private class CellUI
    extends Polygon {
        private final Color bottom = new Color(0, 0, 150);
        private final Color surface = Color.CYAN;
        private final int[][] points = new int[4][2];

        public void draw(int i, int j, int w, int h) {
            this.reset();
            this.points[0] = SpatialMapUI.this.grid2Screen((float)i - 0.5f, (float)j - 0.5f, w, h);
            this.points[1] = SpatialMapUI.this.grid2Screen((float)i + 0.5f, (float)j - 0.5f, w, h);
            this.points[2] = SpatialMapUI.this.grid2Screen((float)i + 0.5f, (float)j + 0.5f, w, h);
            this.points[3] = SpatialMapUI.this.grid2Screen((float)i - 0.5f, (float)j + 0.5f, w, h);
            for (int n = 0; n < 4; ++n) {
                if (this.points[n][0] < 0 || this.points[n][1] < 0) {
                    this.reset();
                    return;
                }
                this.addPoint(this.points[n][0], this.points[n][1]);
            }
        }

        private Color getColor(int i, int j) {
            if (SpatialMapUI.this.isInMap(i, j)) {
                return Color.MAGENTA;
            }
            if (SpatialMapUI.getGrid().getCell(i, j).isLand()) {
                return Color.DARK_GRAY;
            }
            return Color.CYAN;
        }
    }
}

