% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osmplotr.R
\docType{package}
\name{osmplotr}
\alias{osmplotr}
\title{osmplotr.}
\description{
Produces customisable images of OpenStreetMap (OSM) data and enables data
visualisation using OSM objects.  Extracts data using the overpass API.
Contains the following functions, data, and vignettes.
}
\section{Data Functions}{

\itemize{
\item \code{\link{extract_osm_objects}}: Download arbitrary OSM objects
\item \code{\link{connect_highways}}: Returns points sequentially connecting
list of named highways
}
}

\section{Basic Plotting Functions (without data)}{

\itemize{
\item \code{\link{add_axes}}: Overlay longitudinal and latitudinal axes on
plot
\item \code{\link{add_osm_objects}}: Overlay arbitrary OSM objects
\item \code{\link{make_osm_map}}: Automate map production with structures
defined in \code{\link{osm_structures}}
\item \code{\link{osm_structures}}: Define structures and graphics schemes
for automating map production
\item \code{\link{osm_basemap}}: Initiate a \code{ggplot2} object for an OSM
map
\item \code{\link{print_osm_map}}: Print a map to specified graphics
device
}
}

\section{Advanced Plotting Functions (with data)}{

\itemize{
\item \code{\link{add_osm_groups}}: Overlay groups of objects using specified
colour scheme
\item \code{\link{add_osm_surface}}: Overlay data surface by interpolating
given data
\item \code{\link{add_colourbar}}: Overlay a scaled colourbar for data added
with \code{\link{add_osm_surface}}
}
}

\section{Colour Manipulation Functions}{

\itemize{
\item \code{\link{adjust_colours}}: Lighted or darken given colours by
specified amount
\item \code{\link{colour_mat}}: Generate continuous 2D spatial matrix of
colours
}
}

\section{Other Functions}{

\itemize{
\item \code{\link{get_bbox}}: return bounding box from input vector
}
}

\section{Data}{

\itemize{
\item \code{\link{london}}: OSM Data from a small portion of central London
}
}

\section{Vignettes}{

\itemize{
\item \code{basic-maps}: Describes basics of downloading data and making
custom maps
\item \code{data-maps}: Describes how map elements can be coloured according
to user-provided data, whether categorical or continuous
}
}

