% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colocalisationsForGene.R
\name{colocalisationsForGene}
\alias{colocalisationsForGene}
\title{Retrieves Colocalisation Statistics for a Given Gene}
\usage{
colocalisationsForGene(genes)
}
\arguments{
\item{genes}{Character: Gene ENSEMBL ID (e.g. ENSG00000169174) or gene symbol (e.g. PCSK9). Multiple gene IDs are supported as a character vector.}
}
\value{
A data frame (tibble format) including the colocalisation data for the query gene(s).

The output tibble contains the following columns:
\itemize{
  \item{\code{Study}:} Character vector. Study identifier.
  \item{\code{Trait_reported}:} Character vector. Reported trait associated with the colocalisation.
  \item{\code{Lead_variant}:} Character vector. Lead variant associated with the colocalisation.
  \item{\code{Molecular_trait}:} Character vector. Molecular trait associated with the colocalisation.
  \item{\code{Gene_symbol}:} Character vector. Gene symbol associated with the colocalisation.
  \item{\code{Tissue}:} Character vector. Tissue where the colocalisation occurs.
  \item{\code{Source}:} Character vector. Source of the colocalisation data.
  \item{\code{H3}:} Numeric vector. H3 value associated with the colocalisation.
  \item{\code{log2_H4_H3}:} Numeric vector. Log2 ratio of H4 to H3 values.
  \item{\code{Title}:} Character vector. Title of the study.
  \item{\code{Author}:} Character vector. Author(s) of the study.
  \item{\code{Has_sumstats}:} Logical vector. Indicates if the study has summary statistics.
  \item{\code{numAssocLoci}:} Numeric vector. Number of associated loci in the study.
  \item{\code{nInitial_cohort}:} Numeric vector. Number of samples in the initial cohort.
  \item{\code{study_nReplication}:} Numeric vector. Number of samples in the replication cohort.
  \item{\code{study_nCases}:} Numeric vector. Number of cases in the study.
  \item{\code{Publication_date}:} Character vector. Publication date of the study.
  \item{\code{Journal}:} Character vector. Journal where the study was published.
  \item{\code{Pubmed_id}:} Character vector. PubMed identifier of the study.
}
}
\description{
Retrieves Colocalisation statistics for a gene using ENSEMBL gene IDs or gene symbol.
Colocalisation analysis is performed between all studies in the Portal with at least one overlapping
associated locus. This analysis tests whether two independent associations at the same locus are
consistent with having a shared causal variant. The function supports multiple gene IDs as a list.
The returned data frame (tibble format) includes studies that have evidence of colocalisation
with molecular QTLs for the selected gene(s).
}
\examples{
\dontrun{
result1 <- colocalisationsForGene(gene = c("ENSG00000163946", "ENSG00000169174", "ENSG00000143001"))
result2 <- colocalisationsForGene(gene = "ENSG00000169174")
result3 <- colocalisationsForGene(gene = c("TP53", "TASOR"))
result4 <- colocalisationsForGene(gene = "TP53") }

}
