test_that("test plot_coloc works", {
  expected_1 <- otargen::colocalisationsForGene(gene = "ENSG00000169174") %>% otargen::plot_coloc(biobank = TRUE)
  expected_2 <- otargen::colocalisationsForGene(gene = c("ENSG00000167207","ENSG00000096968","ENSG00000138821", "ENSG00000125255")) %>%
                otargen::plot_coloc()
  expected_3 <- otargen::colocalisationsForGene(gene = "TP53") %>% otargen::plot_coloc(biobank = TRUE)
  expected_4 <- otargen::colocalisationsForGene(gene = c("PCSK9", "TASOR", "TP53")) %>% otargen::plot_coloc(biobank = FALSE)
  expect_s3_class(expected_1, "ggplot")
  expect_s3_class(expected_2, "ggplot")
  expect_s3_class(expected_3, "ggplot")
  expect_s3_class(expected_4, "ggplot")
  expect_false(is.null(expected_1))
  expect_false(is.null(expected_2))
  expect_false(is.null(expected_3))
  expect_false(is.null(expected_4))
})
