test_that("otel_decode_log_record_", {
  # fmt: skip
  logmsg <- as.raw(c(
    0x0a, 0xcb, 0x01, 0x0a, 0x8e, 0x01, 0x0a, 0x21, 0x0a, 0x15, 0x74,
    0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x2e, 0x73, 0x64,
    0x6b, 0x2e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x08,
    0x0a, 0x06, 0x31, 0x2e, 0x32, 0x31, 0x2e, 0x30, 0x0a, 0x25, 0x0a,
    0x12, 0x74, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x2e,
    0x73, 0x64, 0x6b, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x0f, 0x0a,
    0x0d, 0x6f, 0x70, 0x65, 0x6e, 0x74, 0x65, 0x6c, 0x65, 0x6d, 0x65,
    0x74, 0x72, 0x79, 0x0a, 0x1f, 0x0a, 0x16, 0x74, 0x65, 0x6c, 0x65,
    0x6d, 0x65, 0x74, 0x72, 0x79, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x6c,
    0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x12, 0x05, 0x0a, 0x03,
    0x63, 0x70, 0x70, 0x0a, 0x21, 0x0a, 0x0c, 0x73, 0x65, 0x72, 0x76,
    0x69, 0x63, 0x65, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x11, 0x0a,
    0x0f, 0x75, 0x6e, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x5f, 0x73, 0x65,
    0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x38, 0x0a, 0x11, 0x0a, 0x0f,
    0x6f, 0x72, 0x67, 0x2e, 0x72, 0x2d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
    0x63, 0x74, 0x2e, 0x52, 0x12, 0x23, 0x09, 0x00, 0x7a, 0x6e, 0x4c,
    0xb0, 0x5f, 0x4e, 0x18, 0x10, 0x09, 0x1a, 0x04, 0x49, 0x4e, 0x46,
    0x4f, 0x2a, 0x07, 0x0a, 0x05, 0x54, 0x65, 0x73, 0x74, 0x21, 0x59,
    0xd0, 0xb3, 0x72, 0x4c, 0xb0, 0x5f, 0x4e, 0x18
  ))

  logs <- ccall(otel_parse_log_record, logmsg)
  lrec <- logs[[1]]$scope_logs[[1]]$log_records[[1]]
  expect_true(is.double(lrec$time_stamp))
  expect_true(length(lrec$time_stamp) == 1)
  expect_true(is.double(lrec$observed_time_stamp))
  expect_true(length(lrec$observed_time_stamp) == 1)
  lrec <- lrec[setdiff(names(lrec), c("time_stamp", "observed_time_stamp"))]
  expect_snapshot(lrec)

  logmsg[1] <- as.raw(0xff)
  expect_snapshot(error = TRUE, ccall(otel_parse_log_record, logmsg))
})

test_that("otel_decode_metrics_record_", {
  # fmt: skip
  metmsg <- as.raw(c(
    0x0a, 0xd0, 0x01, 0x0a, 0x8e, 0x01, 0x0a, 0x21, 0x0a, 0x15, 0x74,
    0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x2e, 0x73, 0x64,
    0x6b, 0x2e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x08,
    0x0a, 0x06, 0x31, 0x2e, 0x32, 0x31, 0x2e, 0x30, 0x0a, 0x25, 0x0a,
    0x12, 0x74, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x2e,
    0x73, 0x64, 0x6b, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x0f, 0x0a,
    0x0d, 0x6f, 0x70, 0x65, 0x6e, 0x74, 0x65, 0x6c, 0x65, 0x6d, 0x65,
    0x74, 0x72, 0x79, 0x0a, 0x1f, 0x0a, 0x16, 0x74, 0x65, 0x6c, 0x65,
    0x6d, 0x65, 0x74, 0x72, 0x79, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x6c,
    0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x12, 0x05, 0x0a, 0x03,
    0x63, 0x70, 0x70, 0x0a, 0x21, 0x0a, 0x0c, 0x73, 0x65, 0x72, 0x76,
    0x69, 0x63, 0x65, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x11, 0x0a,
    0x0f, 0x75, 0x6e, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x5f, 0x73, 0x65,
    0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x3d, 0x0a, 0x11, 0x0a, 0x0f,
    0x6f, 0x72, 0x67, 0x2e, 0x72, 0x2d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
    0x63, 0x74, 0x2e, 0x52, 0x12, 0x28, 0x0a, 0x03, 0x63, 0x74, 0x72,
    0x3a, 0x21, 0x0a, 0x1b, 0x11, 0x18, 0xea, 0x6d, 0x23, 0x04, 0x61,
    0x4e, 0x18, 0x19, 0x60, 0x97, 0xe1, 0x23, 0x04, 0x61, 0x4e, 0x18,
    0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0x40, 0x10, 0x02,
    0x18, 0x01
  ))

  mets <- ccall(otel_parse_metrics_record, metmsg)
  expect_snapshot(mets)

  metmsg[1] <- as.raw(0xff)
  expect_snapshot(error = TRUE, ccall(otel_parse_metrics_record, metmsg))
})

test_that("otel_encode_response_", {
  expect_snapshot(encode_response("traces"))
  expect_snapshot(encode_response(
    "traces",
    "partial-success",
    error_message = "partial fail!",
    rejected = 1L
  ))
  expect_snapshot(encode_response(
    "traces",
    "failure",
    error_message = "fail!",
    error_code = 2L
  ))

  expect_snapshot(encode_response("metrics"))
  expect_snapshot(encode_response(
    "metrics",
    "partial-success",
    error_message = "partial fail!",
    rejected = 1L
  ))

  expect_snapshot(encode_response("logs"))
  expect_snapshot(encode_response(
    "logs",
    "partial-success",
    error_message = "partial fail!",
    rejected = 1L
  ))
})
