% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/execute_script.R
\name{execute_script}
\alias{execute_script}
\title{Generate an environment from an R script}
\usage{
execute_script(script, secret, ignore_errors)
}
\arguments{
\item{script}{The string to be executed}

\item{secret}{The string to be appended to the name \code{check_results_} as the list name to collect
results}

\item{ignore_errors}{Whether to ignore errors thrown while executing the script}
}
\value{
The global environment after executing the script
}
\description{
Execute a string as an R script and return the environment from that execution.

Converts a string to an AST and executes that script in a dummy environment for running test
cases against. Transforms all expressions of the form \code{. = ottr::check(...)} by replacing the \code{.}
with an index into a list in the environment with name \verb{check_results_\{SECRET\}} to collect the
\link{TestFileResult} objects generated from those checks. (This helps to handle variable
name collisions in tests when grading a script.)
}
