% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ouxy.r
\name{ououmodel}
\alias{ououmodel}
\title{Simulate traits under OUOU model given a set of parameters}
\usage{
ououmodel(model.params, reg.params, root = root, tree = tree)
}
\arguments{
\item{model.params}{A vector of model parameters including alpha.y: force parameter of response trait, alpha.x: force parameter of covariate, theta.x: optimum parameter of covariate, sigmasq.x: rate parameter of covariate and tau rate parameter of response trait}

\item{reg.params}{A vector of regression paramters including  b0: intercept parameter of regression, b1: slope parameter of first covariate,  b2: slope paramter of the second covariate}

\item{root}{A vector of numerical values for root of species estimated from \code{OUprior}}

\item{tree}{An ape: tree object stored in phylo format}
}
\value{
Returns the trait vectors \eqn{Y=(y_1,y_2,\cdots,y_n)', X_1=(x_{1,1},x_{1.2},\cdots,x_{1,n})',X_2=(x_{2,1},x_{2,2},\cdots,x_{2,n})'} simulated from the model.
}
\description{
Simulate traits under OUOU model given a set of model parameters, regression parameters, tree and ancestral values.
}
\details{
The model requires user to input  model parameters \eqn{\alpha_y,\alpha_x,\theta_x, \sigma^2_x,\tau} and regression parameters \eqn{b_0,b_1,b_2}, a tree object, trait dataset (one response, two covariate), ancestral values(root) which is estimated by BM or OU model from \code{\link[geiger:fitContinuous]{geiger}}. Then the algorithm starts from the root and apply the tree traversal algorithm to simulate trait on each node according the OUOU dynamics.
}
\examples{
library(ape)
tree<-rcoal(5)
tree<-reorder(tree,"postorder")
root<-list(y.ou.sigmsq=1 ,y.ou.root=0, x1.ou.root=0, x2.ou.root=0,x1.bm.root=0, x2.bm.root=0)
model.params<-c(0.5,0.25,0,1,0.2)
names(model.params)<-c("alpha.y","alpha.x","theta.x","sigmasq.x","tau")
reg.params<-c(0,1,1)
names(reg.params)<-c("b0","b1","b2")
ououmodel(model.params,reg.params,root=root,tree=tree)


}
\references{
\enumerate{
  \item Jhwueng, D-C. (2019) Statistical modeling for adaptive trait evolution. Under review.
  \item Jhwueng, D-C., and Vasileios Maroulas. "Adaptive trait evolution in random environment." Journal of Applied Statistics 43.12 (2016): 2310-2324.
  \item Hansen, Thomas F., Jason Pienaar, and Steven Hecht Orzack. "A comparative method for studying adaptation to a randomly evolving environment." Evolution: International Journal of Organic Evolution 62.8 (2008): 1965-1977.
}
}
