% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OWSServiceProvider.R
\docType{class}
\name{OWSServiceProvider}
\alias{OWSServiceProvider}
\title{OWSServiceProvider}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling an OGC Service Provider
}
\description{
OWSServiceProvider

OWSServiceProvider
}
\note{
Abstract class used internally by \pkg{ows4R}
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{OGC}
\keyword{OWS}
\keyword{Provider}
\keyword{Service}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-OWSServiceProvider-new}{\code{OWSServiceProvider$new()}}
\item \href{#method-OWSServiceProvider-getProviderName}{\code{OWSServiceProvider$getProviderName()}}
\item \href{#method-OWSServiceProvider-getProviderSite}{\code{OWSServiceProvider$getProviderSite()}}
\item \href{#method-OWSServiceProvider-getServiceContact}{\code{OWSServiceProvider$getServiceContact()}}
\item \href{#method-OWSServiceProvider-clone}{\code{OWSServiceProvider$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OWSServiceProvider-new"></a>}}
\if{latex}{\out{\hypertarget{method-OWSServiceProvider-new}{}}}
\subsection{Method \code{new()}}{
Initializes an object of class \link{OWSServiceProvider}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OWSServiceProvider$new(xmlObj, owsVersion, serviceVersion)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xmlObj}}{object of class \link{XMLInternalNode-class} from \pkg{XML}}

\item{\code{owsVersion}}{OWS version}

\item{\code{serviceVersion}}{service version}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OWSServiceProvider-getProviderName"></a>}}
\if{latex}{\out{\hypertarget{method-OWSServiceProvider-getProviderName}{}}}
\subsection{Method \code{getProviderName()}}{
Get provider name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OWSServiceProvider$getProviderName()}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{the}}{provider name, object of class \code{character}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OWSServiceProvider-getProviderSite"></a>}}
\if{latex}{\out{\hypertarget{method-OWSServiceProvider-getProviderSite}{}}}
\subsection{Method \code{getProviderSite()}}{
Get provider site
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OWSServiceProvider$getProviderSite()}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{the}}{provider site, object of class \code{character}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OWSServiceProvider-getServiceContact"></a>}}
\if{latex}{\out{\hypertarget{method-OWSServiceProvider-getServiceContact}{}}}
\subsection{Method \code{getServiceContact()}}{
Get provider contact
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OWSServiceProvider$getServiceContact()}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{the}}{provider contact, object of class \link{ISOResponsibleParty} from \pkg{geometa}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OWSServiceProvider-clone"></a>}}
\if{latex}{\out{\hypertarget{method-OWSServiceProvider-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OWSServiceProvider$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
