% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/audit_deps.R
\name{audit_deps}
\alias{audit_deps}
\title{Check Package Dependencies

Collects R dependencies and checks them against OSS Index.
Returns a tibble of results.}
\usage{
audit_deps(pkgs = NULL, verbose = TRUE)
}
\arguments{
\item{pkgs}{Default \code{NULL}. See details for further information.}

\item{verbose}{Default \code{TRUE}.}
}
\value{
A tibble/data.frame.
}
\description{
Check Package Dependencies

Collects R dependencies and checks them against OSS Index.
Returns a tibble of results.
}
\details{
By default, packages listed in \code{installed.packages()} are scanned by sonatype.
However, you can pass your own data frame of packages. This data frame should have two columns,
\code{version} and \code{package}.
}
\examples{
\donttest{
# Audit installed packages
# This calls installed.packages()
# pkgs = audit_deps()

# Or pass your own packages
pkgs = data.frame(package = c("abind", "acepack"),
                  version = c("1.4-5", "1.4.1"))
audit_deps(pkgs)
}
}
