% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappingFunctions.R
\name{PM.trainModel}
\alias{PM.trainModel}
\title{A trainer for a Process Mining model (wrapping function)}
\usage{
PM.trainModel(PM.obj)
}
\arguments{
\item{PM.obj}{a Process Mining model previously instantiated via the appropriate class (in example \code{alphaAlgorithm()}  or \code{firstOrderMarkovModel()}) or \code{AA.builder() } wrapper function}
}
\description{
This function wraps the \code{<object>::train() } method and trains the Process Mining model. The model has to be previously loaded with a loader, as shown in the examples below
}
\examples{
\dontrun{
# Instantiate a'firstOrderMarkovModel' model
obj.LD<-LD.builder()

# Load a CSV into the loader
LD.load.csv(loader.obj = obj.LD ,nomeFile = "../csv/dati_retto.csv",
                     IDName = "CODICE_SANITARIO_ADT",EVENTName = "CAT1")

# Instantiate a PM model
obj.PM <-PM.builder(kindOfObject = "firstOrderMarkovModel")

# Load the previously loaded csv into the PM model
PM.loadDataset(PM.obj = obj.PM,dataList = LD.getData(loader.obj = obj.LD))

# train the model! 
PM.trainModel(PM.obj = obj.PM)
}
}

