% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pRecipe.R
\name{crop_data}
\alias{crop_data}
\title{Crop precipitation data sets}
\usage{
crop_data(x, shp_path)
}
\arguments{
\item{x}{a pRecipe data.table imported using \code{\link{import_full_data}} or \code{\link{import_subset_data}}.}

\item{shp_path}{a character string with the path to the ".shp" file.}
}
\value{
a data.table with the cropped data sets
}
\description{
The function \code{crop_data} crops the data sets using a shapefile mask.
}
\examples{
\dontrun{
x <- import_full_data(c("cru_ts", "cpc", "ghcn", "gpcp"), tempdir())
w <- crop_data(x, "cze.shp")
y <- import_subset_data(c("cru_ts", "cpc", "ghcn", "gpcp"), 2000, 2009, 
c(12.24, 48.56, 18.85, 51.12), tempdir())
z <- crop_data(y, "cze.shp")
}
}
