% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3c_costing_resource_use_functions.R
\name{get_cost_ip_dc_hrg}
\alias{get_cost_ip_dc_hrg}
\title{Function to extract the unit hospital inpatient admission by
matching HRG code}
\usage{
get_cost_ip_dc_hrg(
  hrg,
  ref_cost_data_file,
  col_name_hrg_code,
  unit_cost_col,
  sheet = NULL
)
}
\arguments{
\item{hrg}{hrg code corresponding to the inpatient admission}

\item{ref_cost_data_file}{file that has unit cost}

\item{col_name_hrg_code}{name of the column that has the hrg code}

\item{unit_cost_col}{name of the colum with the unit cost}

\item{sheet}{sheet if excel file is given}
}
\value{
unit cost the unit cost matching the hrg code
}
\description{
Function to extract the unit hospital inpatient admission by
matching HRG code
}
\examples{
ref_cost_data_file <- system.file("extdata",
"National_schedule_of_NHS_costs_2019.csv", package = "packDAMipd")
get_cost_ip_dc_hrg("AA22C", ref_cost_data_file, "Currency_Code",
"National_Average_Unit_Cost")
}
