% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3d_decision_analysis_functions.R
\name{plot_ceac}
\alias{plot_ceac}
\title{Plot cost effectiveness acceptability curve}
\usage{
plot_ceac(list_markov, threshold_values, comparator, currency = "GBP")
}
\arguments{
\item{list_markov}{markov_model objects}

\item{threshold_values}{list of threshold values}

\item{comparator}{the comparator}

\item{currency}{currency}
}
\value{
plots
}
\description{
Plot cost effectiveness acceptability curve
}
\examples{
\donttest{
well <- health_state("well", cost = 0, utility = 1)
disabled <- health_state("disabled", cost = 100, utility = 1)
dead <- health_state("dead", cost = 0, utility = 0)
tmat <- rbind(c(1, 2, 3), c(NA, 4, 5), c(NA, NA, 6))
colnames(tmat) <- rownames(tmat) <- c("well", "disabled", "dead")
tm <- populate_transition_matrix(3, tmat, c(0.6, 0.2, 0.2, 0.6, 0.4, 1),
colnames(tmat))
health_states <- combine_state(well, disabled, dead)
this.strategy <- strategy(tm, health_states, "control")
this_markov <- markov_model(this.strategy, 24, c(1000, 0, 0),c(0, 0))
well <- health_state("well", cost = 0, utility = 1)
disabled <- health_state("disabled", cost = 10, utility = 0.5)
dead <- health_state("dead", cost = 0, utility = 0)
tmat <- rbind(c(1, 2, 3), c(NA, 4, 5), c(NA, NA, 6))
colnames(tmat) <- rownames(tmat) <- c("well", "disabled", "dead")
tm <- populate_transition_matrix(3, tmat, c(0.4, 0.4, 0.2, 0.6, 0.4, 1),
colnames(tmat))
health_states <- combine_state(well, disabled, dead)
this.strategy <- strategy(tm, health_states, "intervention")
sec_markov <- markov_model(this.strategy, 24, c(1000, 0, 0), c(0, 0))
list_markov <- combine_markov(this_markov, sec_markov)
plot_ceac(list_markov, c(1000, 2000, 3000), comparator = "control")
}
}
