% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/circleVertices.R
\name{circleLayoutVertices}
\alias{circleLayoutVertices}
\title{Generate a set of circle vertices suitable for plotting}
\usage{
circleLayoutVertices(
  layout,
  npoints = 25,
  xysizecols = 1:3,
  sizetype = c("radius", "area"),
  idcol = NULL
)
}
\arguments{
\item{layout}{A matrix or data.frame of circle data (x, y, size). May also 
contain other columns including an optional identifier column.}

\item{npoints}{The number of vertices to generate for each circle.}

\item{xysizecols}{The integer indices or names of columns for the centre X, 
centre Y and size values. Default is `c(1,2,3)`.}

\item{sizetype}{The type of size values: either \code{"radius"} (default) or 
\code{"area"}. May be abbreviated.}

\item{idcol}{Optional index or name of column for circle identifiers. These 
may be numeric or character but must be unique. If not provided, the output
circle IDs will be the row numbers of the input circle data.}
}
\value{
A data.frame with columns: id, x, y; where id is the unique integer 
  identifier for each circle.
}
\description{
Given a matrix or data frame for a circle layout, with columns for centre x-y
coordinates and sizes, this function generates a data set of vertices which 
can then be used with ggplot or base graphics functions.
}
\note{
\strong{Input sizes are assumed to be radii}. This is slightly confusing
  because the layout functions \code{circleRepelLayout} and 
  \code{circleProgressiveLayout} treat their input sizes as areas by default.
  To be safe, you can always set the \code{sizetype} argument explicitly
  for both this function and layout functions.
}
\examples{
xmax <- 100
ymax <- 100
rmin <- 10
rmax <- 20
N <- 20

## Random centre coordinates and radii
layout <- data.frame(id = 1:N,
                     x = runif(N, 0, xmax), 
                     y = runif(N, 0, ymax), 
                     radius = runif(N, rmin, rmax))

## Get data for circle vertices
verts <- circleLayoutVertices(layout, idcol=1, xysizecols=2:4,
                              sizetype = "radius")

\dontrun{
library(ggplot2)

## Draw circles annotated with their IDs
ggplot() + 
  geom_polygon(data = verts, aes(x, y, group = id), 
               fill = "grey90", 
               colour = "black") +
               
  geom_text(data = layout, aes(x, y, label = id)) + 
  
  coord_equal() +
  theme_bw()
}

}
\seealso{
\code{\link{circleVertices}}
}
