% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test.R
\name{tests}
\alias{tests}
\alias{include_tests}
\alias{add_test_file}
\alias{run_tests}
\title{Add Tests}
\usage{
include_tests(esm = TRUE)

add_test_file(name)

run_tests()
}
\arguments{
\item{esm}{Whether to install \code{esm} and require it for tests (recommended).}

\item{name}{Name of the test file to add, without extension.}
}
\description{
Adds tests to a project.
}
\details{
Uses \href{https://mochajs.org/}{mocha} and
\href{https://webpack.js.org/loaders/mocha-loader/}{mocha-webpack} and
creates a directory called \code{testjs} where tests should be placed.
The function \code{\link[=run_tests]{run_tests()}} will then uses mocha on all the files in
the \code{testjs} directory. All tests should end with \code{.test.js}. Internally
\code{\link[=include_tests]{include_tests()}} also runs \code{\link[=use_loader_mocha]{use_loader_mocha()}}.

Requiring \code{esm} (\code{esm = TRUE}) is recommended as it will allow using the latest
ESM, e.g.: \code{import} in tests.
}
